package cn.com.duiba.goods.center.biz.service.item.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.biz.bo.GoodsCouponBO;
import cn.com.duiba.goods.center.biz.dao.item.AppItemDao;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;

@Service("appItemService")
public class AppItemServiceImpl implements AppItemService {

	@Autowired
	private AppItemDao appItemDao;

	@Autowired
	private ItemService itemService;

	@Autowired
	private GoodsCouponBO goodsCouponBO;

	@Autowired
	private GoodsBatchService goodsBatchService;

	@Override
	public AppItemEntity find(Long id) {
		AppItemEntity entity = appItemDao.find(id);
		if (entity == null) {
			return null;
		}
		if (entity.isOpTypeAppItem(ItemDto.OpTypeGoodsCoupon)) {
			Long stock = goodsBatchService.getSumBatchStockBatch(GoodsTypeEnum.APP, entity.getId());
			if (stock != null) {
				entity.setRemaining(Integer.valueOf(stock.toString()));
			}
		}
		return entity;
	}

	@Override
	public List<AppItemEntity> findByIds(List<Long> ids) {
		List<AppItemEntity> entitys = appItemDao.findByIds(ids);
		List<GoodsStockDto> stocks = new ArrayList<>();
		for (AppItemEntity entity : entitys) {
			if (entity.isOpTypeAppItem(ItemDto.OpTypeGoodsCoupon)) {
				GoodsStockDto stock = new GoodsStockDto();
				stock.setGid(entity.getId());
				stock.setGtype(GoodsTypeEnum.APP);
				stocks.add(stock);
			}
		}
		if (stocks.size() > 0) {
			List<GoodsStockDto> gst = goodsCouponBO.findGoodsStockByBatch(stocks);
			Map<Long, Long> map = new HashMap<>();
			for (GoodsStockDto dto : gst) {
				map.put(dto.getGid(), dto.getStock());
			}
			for (AppItemEntity entity : entitys) {
				if (entity.isOpTypeAppItem(ItemDto.OpTypeGoodsCoupon)) {
					Long stock = map.get(entity.getId());
					if (stock != null) {
						entity.setRemaining(Integer.valueOf(stock.toString()));
					}
				}
			}
		}
		return entitys;
	}

	@Override
	public Long insert(AppItemEntity appItemEntity) {
		appItemDao.insert(appItemEntity);
		return appItemEntity.getId();
	}

	@Override
	public Boolean update(AppItemEntity appItemEntity) {
		int ret = appItemDao.update(appItemEntity);
		if (ret > 0) {
			return true;
		}
		return false;
	}

	@Override
	public Boolean delete(Long appId, Long appItemId) {
		int ret = appItemDao.delete(appId, appItemId);
		if (ret > 0) {
			return true;
		}
		return false;
	}

	@Override
	public Integer deleteByIds(Long appId, List<Long> appItemId) {
		return appItemDao.deleteByIds(appId, appItemId);
	}

	@Override
	public Boolean updateStatus(Long appId, Long appItemId, String status) {
		int ret = appItemDao.updateStatus(appId, appItemId, status);
		if (ret > 0) {
			return true;
		}
		return false;
	}

	@Override
	public Integer updateStatusByIds(Long appId, List<Long> appItemIds, String status) {
		return appItemDao.updateStatusByIds(appId, appItemIds, status);
	}

	@Override
	public Boolean decrStock(Long appId, Long appItemId) {
		int ret = appItemDao.decrStock(appItemId);
		if (ret > 0) {
			return true;
		}
		return false;
	}

	@Override
	public Boolean incrStock(Long appItemId) {
		int ret = appItemDao.incrStock(appItemId);
		if (ret > 0) {
			return true;
		}
		return false;
	}

	@Override
	public Boolean appendStock(Long appId, Long appItemId, Long number) {
		int ret = appItemDao.appendStock(appItemId, number);
		if (ret > 0) {
			return true;
		}
		return false;
	}

	@Override
	public Boolean deductStock(Long appId, Long appItemId, Long number) {
		int ret = appItemDao.deductStock(appItemId, number);
		if (ret > 0) {
			return true;
		}
		return false;
	}

	@Override
	public AppItemEntity findByAppIdAndItemId(Long appId, Long itemId) {
		return appItemDao.findByAppIdAndItemId(appId, itemId);
	}

	@Override
	public int updateRemainingAndvalidEndDate(Long appItemId, Long totalStock, Date validEndDate) {
		return appItemDao.updateRemainingAndvalidEndDate(appItemId, totalStock, validEndDate);
	}

	@Override
	public int updateExpiedAppItem(Long itemId) {
		return appItemDao.updateExpiedAppItem(itemId);
	}

	@Override
	public int updateExpiedAppItemById(Long appItemId) {
		return appItemDao.updateExpiedAppItemById(appItemId);
	}

}
