package cn.com.duiba.goods.center.biz.service.item.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.entity.PreStockPointEntity;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.EverydayLimitService;
import cn.com.duiba.goods.center.biz.service.item.ItemKeyService;
import cn.com.duiba.goods.center.biz.service.item.ItemKeyStockService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.biz.service.item.PreStockService;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.wolf.utils.BeanUtils;

@Service
public class ItemKeyServiceImpl implements ItemKeyService {

	@Autowired
	private AppItemService appItemService;
	@Autowired
	private ItemService itemService;
	@Autowired
	private PreStockService preStockService;
	@Autowired
	private ItemKeyStockService itemKeyStockService;
	@Autowired
	private EverydayLimitService everydayLimitService;

	@Override
	public ItemKeyDto findItemKey(Long appItemId, Long itemId, Long appId) {
		AppItemEntity appItemEntity = null;
		ItemEntity itemEntity = null;
		if (appItemId != null) {
			appItemEntity = appItemService.find(appItemId);
			if (appItemEntity != null && appItemEntity.getItemId() != null) {
				itemEntity = itemService.find(appItemEntity.getItemId());
			}
		} else if (itemId != null) {
			itemEntity = itemService.find(itemId);
			appItemEntity = appItemService.findByAppIdAndItemId(appId, itemId);
		}
		AppItemDto appItemDto = null;
		if (appItemEntity != null) {
			appItemDto = BeanUtils.copy(appItemEntity, AppItemDto.class);
		}
		ItemDto itemDto = null;
		if (itemEntity != null) {
			itemDto = BeanUtils.copy(itemEntity, ItemDto.class);
		}
		return new ItemKeyDto(appItemDto, itemDto, appId);
	}

	@Override
	public Long findStock(ItemKeyDto itemKeyDto) {
		Long stock = 0L;
		if (itemKeyDto.isSelfAppItemMode()) {
			AppItemEntity entity = appItemService.find(itemKeyDto.getAppItemDto().getId());
			// 商品库存
			if (entity.getRemaining() != null) {
				stock = Long.valueOf(entity.getRemaining());
			}
			// 每日限量库存
			Long everydayStock = everydayLimitService.findEverydayStock(itemKeyDto);
			if (everydayStock != null && everydayStock <= stock) {
				stock = everydayStock;
			}
		} else if (itemKeyDto.isItemMode() || itemKeyDto.isDuibaAppItemMode()) {
			ItemEntity entity = itemService.find(itemKeyDto.getItemDto().getId());
			// 商品库存
			if (entity.getRemaining() != null) {
				stock = Long.valueOf(entity.getRemaining());
			}
			// 直充类不需要库存商品
			if (itemService.isRechargeGoods(entity)) {
				return 1L;
			}
			// 取定向库存
			if (stock != null && stock > 0 && entity.isOpTypeItem(ItemDO.OpTypeSpecify)) {
				Long specifyStock = itemService.findSpecifyRemaining(entity.getId(), itemKeyDto.getAppId());
				if (specifyStock != null && specifyStock <= stock) {
					stock = specifyStock;
				}
			}
			// 预分配库存
			if (stock != null && stock > 0 && entity.isOpTypeItem(ItemDO.OpTypePreStockSwith)) {
				Long preStock = preStockService.getPreStock(entity, itemKeyDto.getAppId());
				if (preStock != null && preStock <= stock) {
					stock = preStock;
				}
			}
			// 每日限量库存
			Long everydayStock = everydayLimitService.findEverydayStock(itemKeyDto);
			if (everydayStock != null && everydayStock <= stock) {
				stock = everydayStock;
			}
		}
		return stock;
	}

	@Override
	public Boolean consumeStock(ItemKeyDto itemKeyDto, String bizId, String bizSource) {
		boolean decrStock = false;
		boolean decrPreStock = false;
		boolean decrAppSpecifyStock = false;
		boolean decrEverydayStock = false;
		try {
			// 扣商品库存
			if (!itemKeyDto.getItemDtoType().equals(ItemDO.TypeObject) && !itemKeyDto.getItemDtoType().equals(ItemDO.TypeVirtual)) {
				decrStock = itemKeyStockService.decrStock(itemKeyDto, bizId, bizSource);
			}
			if (itemKeyDto.isDuibaAppItemMode() || itemKeyDto.isItemMode()) {
				ItemEntity itemEntity = itemService.find(itemKeyDto.getItemDto().getId());
				// 扣预分配库存
				PreStockPointEntity pointStock = preStockService.getPointStock(itemEntity, itemKeyDto.getAppId());
				if (pointStock != null) {
					decrPreStock = itemKeyStockService.decrPreStock(itemKeyDto.getAppId(), itemEntity.getId(), pointStock, bizId, bizSource);
				}
				// 扣定向库存
				if (!ItemDO.TypeObject.equals(itemKeyDto.getItemDtoType()) && !ItemDO.TypeCoupon.equals(itemEntity.getType())) {
					decrAppSpecifyStock = itemKeyStockService.decrAppSpecifyStock(itemKeyDto.getAppId(), itemEntity, bizId, bizSource);
				}
			}
			// 扣每日限量库存
			if (everydayLimitService.isEverydayLimit(itemKeyDto)) {
				decrEverydayStock = itemKeyStockService.decrEverydayStock(itemKeyDto);
			}
			return true;
		} catch (GoodsException e) {
			// 返还商品库存
			if (decrStock) {
				itemKeyStockService.rollbackStock(bizId, bizSource);
			}
			// 返还预分配库存
			if (decrPreStock) {
				itemKeyStockService.rollbackPreStock(bizId);
			}
			// 返还定向库存
			if (decrAppSpecifyStock) {
				itemKeyStockService.rollbackAppSpecifyStock(bizId, bizSource);
			}
			// 返还每日限量库存
			if (decrEverydayStock) {
				itemKeyStockService.rollbackEverydayStock(itemKeyDto);
			}
		}
		return false;
	}

	@Override
	public Boolean rollbackStock(ItemKeyDto itemKeyDto, String bizId, String bizSource) {
		if (!itemKeyDto.getItemDtoType().equals(ItemDO.TypeObject) && !itemKeyDto.getItemDtoType().equals(ItemDO.TypeVirtual)) {
			// 返还商品库存
			itemKeyStockService.rollbackStock(bizId, bizSource);
		}
		if (itemKeyDto.isDuibaAppItemMode() || itemKeyDto.isItemMode()) {
			ItemEntity itemEntity = itemService.find(itemKeyDto.getItemDto().getId());
			// 返还预分配库存
			PreStockPointEntity pointStock = preStockService.getPointStock(itemEntity, itemKeyDto.getAppId());
			if (pointStock != null) {
				itemKeyStockService.rollbackPreStock(bizId);
			}
			// 返还定向库存
			if (!ItemDO.TypeObject.equals(itemKeyDto.getItemDtoType()) && !ItemDO.TypeCoupon.equals(itemEntity.getType())) {
				itemKeyStockService.rollbackAppSpecifyStock(bizId, bizSource);
			}
		}
		if (everydayLimitService.isEverydayLimit(itemKeyDto)) {
			// 返还每日限量库存
			itemKeyStockService.rollbackEverydayStock(itemKeyDto);
		}
		return true;
	}
}
