package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.enums.ItemMarkEnum;
import cn.com.duiba.goods.center.biz.service.item.MobileShowItemService;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import org.springframework.stereotype.Service;

@Service("mobileShowItemService")
public class MobileShowItemServiceImpl implements MobileShowItemService {

    @Override
    public ItemMarkEnum getMarkType(ItemKeyDto itemKey) {
        if (itemKey.isDuibaAppItemMode()) {
            // 秒杀（限时）
            if (itemKey.getAppItemDto().isOpTypeAppItem(ItemDO.OpTypeTimeLimit) || itemKey.getItemDto().isOpTypeItem(ItemDO.OpTypeTimeLimit)) {
                return ItemMarkEnum.MARK_TIME;
                // 地域限制
            } else if (itemKey.getAppItemDto().isOpTypeAppItem(ItemDO.OpTypeAddrLimit) || itemKey.getItemDto().isOpTypeItem(ItemDO.OpTypeAddrLimit)) {
                return ItemMarkEnum.MARK_ADDRLIMIT;
            }
        } else if (itemKey.isItemMode()) {
            // 秒杀（限时）
            if (itemKey.getItemDto().isOpTypeItem(ItemDO.OpTypeTimeLimit)) {
                return ItemMarkEnum.MARK_TIME;
                // 地域限制
            }else if (itemKey.getItemDto().isOpTypeItem(ItemDO.OpTypeAddrLimit)) {
                return ItemMarkEnum.MARK_ADDRLIMIT;
            }
        } else if (itemKey.isSelfAppItemMode()) {
            if (itemKey.getAppItemDto().isOpTypeAppItem(ItemDO.OpTypeAddrLimit)) {
                //地域限制
                return ItemMarkEnum.MARK_ADDRLIMIT;
            }else if (itemKey.getAppItemDto().isOpTypeAppItem(ItemDO.OpTypeTimeLimit)) {
                // 秒杀（限时）
                return ItemMarkEnum.MARK_TIME;
            }else if (itemKey.getAppItemDto().getSourceType() == AppItemDO.SourceTypeSingleLottery
                      || itemKey.getAppItemDto().getSourceType() == AppItemDO.SourceTypeOperatingActivity
                      || itemKey.getAppItemDto().getSourceType() == AppItemDO.SourceTypeManualLottery
                      || itemKey.getAppItemDto().getSourceType() == AppItemDO.SourceTypeAppShakeLottery
                      || itemKey.getAppItemDto().getSourceType() == AppItemDO.SourceTypeHdtoolTiger
                      || itemKey.getAppItemDto().getSourceType() == AppItemDO.SourceTypeHdtoolTurntable
                      || itemKey.getAppItemDto().getSourceType() == AppItemDO.SourceTypeGameSanta
                      || itemKey.getAppItemDto().getSourceType() == AppItemDO.SourceTypeGameYearAward
                      || itemKey.getAppItemDto().getSourceType() == AppItemDO.SourceTypeGameGirl
                      || itemKey.getAppItemDto().getSourceType() == AppItemDO.SourceTypeGameJiong
                      || itemKey.getAppItemDto().getSourceType() == AppItemDO.SourceTypeDuibaQuestionAnswer
                      || itemKey.getAppItemDto().getSourceType() == AppItemDO.SourceTypeDuibaQuizz
                      || itemKey.getAppItemDto().getSourceType() == AppItemDO.SourceTypeNgame
                      || itemKey.getAppItemDto().getSourceType() == AppItemDO.SourceTypeGuess) {
                // 抽奖
                return ItemMarkEnum.MARK_LOTTERY;
                // 专题活动的 兑换项
                //            } else if (itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeDuibaActivityItem) {
                //                ItemKey duibaActivityItemKey = remoteItemKeyService.getItemKey(itemKey.getAppItem().getSourceRelationId(), null, itemKey.getApp());
                //                // 秒杀（限时）
                //                if (duibaActivityItemKey.getItem().isOpTypeItem(ItemDO.OpTypeTimeLimit)) {
                //                    return ItemMarkEnum.MARK_TIME;
                //                    // 限量
                //                } else if (duibaActivityItemKey.getItem().isOpTypeItem(ItemDO.OpTypeQuantityLimit)) {
                //                    return ItemMarkEnum.MARK_QUANTITY;
                //                }
                //
                //                return ItemMarkEnum.MARK_NORMAL;
                //                // 专题活动的 单品
                //            } else if (itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeDuibaActivitySingleLottery) {
                //                return ItemMarkEnum.MARK_LOTTERY;
                /** 专题活动,主推的兑换项,已经不再用了,此处已经问过@周周,后面有 bug,找到此处,可以和运营进行对质 **/
            }
        }
        return ItemMarkEnum.MARK_NORMAL;
    }
}
