package cn.com.duiba.goods.center.biz.service.stock;

/**
 * 基于redis 库存管理
 * @author houwen
 */
public interface MemStockService {
	
	/**
	 * 获取分布式锁失败尝试 共 3 次
	 * @param key
	 * @return
	 */
	public boolean getLock(String key);
	public boolean getLock(String key, int timeout);
	
	/**
	 * 解锁
	 * @param key
	 * @return
	 */
	public void unlock(String key);
	
	/**
	 * 每日限制库存
	 * @param key
	 * @param limitStock
	 * @return
	 */
	public boolean everydayStock(String key, Integer limitStock);
	
}
