package cn.com.duiba.goods.center.biz.util;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.AppendObjectRequest;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.ObjectMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

/**
 * This sample demonstrates how to upload an object by append mode 
 * to Aliyun OSS using the OSS SDK for Java.
 */
@Component
public class AppendUploadUtil {

    private static final Logger LOG = LoggerFactory.getLogger(AppendUploadUtil.class);

    @Value("${goods.oss.endPoint}")
    private String endpoint;
    @Value("${goods.oss.accessId}")
    private String accessKeyId;
    @Value("${goods.oss.accessKey}")
    private String accessKeySecret;

    @Value("${goods.oss.bucketName}")
    private String bucketName;


    private String key;


    public Long upload(String content , Long position) throws Exception {
        OSSClient client = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        AppendObjectResult appendObjectResult = null;
        try {

            // 创建上传Object的Metadata
            ObjectMetadata meta = new ObjectMetadata();
            // 设置上传内容类型
            meta.setContentType("application/octet-stream");

            InputStream instream = new ByteArrayInputStream(content.getBytes());
            appendObjectResult = client.appendObject(new AppendObjectRequest(bucketName, key, instream,meta).withPosition(position));
        } catch (Exception e) {
            LOG.error("oss上传异常", e);
            throw e;
        } finally {
            client.shutdown();
        }
        return appendObjectResult.getNextPosition();
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}