/**
 * Project Name:goods-center-biz
 * File Name:PcgCreditsCalculteTool.java
 * Package Name:cn.com.duiba.goods.center.biz.util
 * Date:2016年6月28日下午1:48:36
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.util;


/**
 * ClassName:PcgCreditsCalculteTool <br/>
 * Function: 平台券积分计算工具类. <br/>
 * Date:     2016年6月28日 下午1:48:36 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class PcgCreditsCalculteTool {
    /**
     * 根据兑吧最小价格折算在App中需要的积分
     *
     * @author xuhengfei
     * @param duibaPrice 兑吧设定的价格，单位是分
     * @param creditsRate 积分汇率，表示1元对应多少个积分
     * @return
     * @since JDK 1.6
     */
    public static Long getCredits(long duibaPrice,long creditsRate){
        
        long credits = (long) Math.ceil(duibaPrice * creditsRate / 100.0);
        //积分最小值为1
        if(credits<1L){
            credits = 1L;
        }
        return credits;
    }
}

