/**
 * Project Name:goods-center-biz File Name:GoodsBatchCouponBackendBO.java Package Name:cn.com.duiba.goods.center.biz.bo
 * Date:2016年6月5日下午12:50:39 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.goods.center.biz.bo;

import java.util.Date;
import java.util.List;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchImportLogDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.common.GoodsException;

/**
 * ClassName:GoodsBatchCouponBackendBO <br/>
 * Date: 2016年6月5日 下午12:50:39 <br/>
 * 
 * @author xuhengfei
 * @version
 * @since JDK 1.6
 * @see
 */
public interface GoodsBatchCouponBackendBO {

    /**
     * createNormalBatch:创建一个普通的优惠券批次. <br/>
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param start 有效期开始时间
     * @param end 有效期截止时间
     * @return 批次id
     * @since JDK 1.6
     */
    public Long createNormalBatch(GoodsTypeEnum gtype, long gid, Date start, Date end) throws GoodsException;

    /**
     * 创建链接券批次
     * @param gtype
     * @param gid
     * @param start
     * @param end
     * @param link
     * @param stock
     * @return
     * @throws GoodsException
     */
    public Long createLinkBatch(GoodsTypeEnum gtype, long gid, Date start, Date end, String link, long stock)
                                                                                                             throws GoodsException;

    /**
     * 创建重复券批次
     * @param gtype
     * @param gid
     * @param start
     * @param end
     * @param code
     * @param password
     * @param stock
     * @return
     * @throws GoodsException
     */
    public Long createRepeatBatch(GoodsTypeEnum gtype, long gid, Date start, Date end, String code, String password,
                                  long stock) throws GoodsException;

    /**
     * 修改链接券批次
     * @param gtype
     * @param gid
     * @param batchId
     * @param link
     * @param changeStock
     * @return
     */
    public Boolean updateLinkBatch(GoodsTypeEnum gtype, long gid, Long batchId, String link, long changeStock);

    /**
     * 修改重复券批次
     * @param gtype
     * @param gid
     * @param batchId
     * @param code
     * @param password
     * @param changeStock
     * @return
     */
    public Boolean updateRepeatBatch(GoodsTypeEnum gtype, long gid, Long batchId, String code, String password,
                                     long changeStock);

    /**
     * 查询商品批次
     * @param gtype
     * @param gid
     * @return
     */
    public List<GoodsBatchDto> findBatchs(GoodsTypeEnum gtype, long gid);

    /**
     * importNormalCoupons:导入普通券码 <br/>
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param batchId
     * @param downloadUrl 券码附件的下载地址
     * @return 导入券码的日志id，通过此id再调用 findBatchImportLog 来查询进度和结果
     * @since JDK 1.6
     */
    public Long importNormalCoupons(GoodsTypeEnum gtype, long gid, Long batchId, String downloadUrl);

    /**
     * 查询导入的进度个结果
     *
     * @author xuhengfei
     * @param goodsBatchImportLogId
     * @return
     * @since JDK 1.6
     */
    public GoodsBatchImportLogDto findBatchImportLog(Long goodsBatchImportLogId);

    /**
     * 删除批次
     * @param gtype
     * @param gid
     * @param batchId
     * @return
     */
    public Boolean deleteBatch(GoodsTypeEnum gtype, long gid, Long batchId);

    /**
     * 查询券码分页
     * @param gtype
     * @param gid
     * @param batchId
     * @param pageSize
     * @param pageIndex
     * @return
     */
    public Page<GoodsCouponDto> findPage(GoodsTypeEnum gtype, long gid, long batchId, int pageSize, int pageIndex);

    /**
     * 查询批次库存
     * @param gtype
     * @param gid
     * @param batchId
     * @return
     */
    public GoodsBatchDto findBatchStock(GoodsTypeEnum gtype, long gid, long batchId);

    /**
     * 查询券码
     * @param gtype
     * @param gid
     * @param batchId
     * @param code
     * @return
     */
    public List<GoodsCouponDto> findCouponByCode(GoodsTypeEnum gtype, long gid, long batchId, String code);
    
    /**
     * 查询券码
     * @param gtype
     * @param gid
     * @param couponId
     * @return
     */
    public GoodsCouponDto findCoupon(GoodsTypeEnum gtype, long gid,long couponId);
    
    /**
     * 删除一张未使用的券
     * @param gtype
     * @param gid
     * @param couponId
     * @param batchId
     * @return
     */
    public Boolean deleteUnusedCoupon(GoodsTypeEnum gtype, long gid, Long couponId, Long batchId);
    /**
     * 删除一个批次下未使用的优惠劵
     * 执行时先获取内存锁，避免并发
     * @param gtype
     * @param gid
     * @param batchId
     * @return
     */
    public Boolean deleteBatchUnusedCoupons(GoodsTypeEnum gtype, long gid, Long batchId);
    /**
     * 删除指定数量的优惠券
     * @param gtype
     * @param gid
     * @param batchId
     * @param couponIds
     * @return
     */
    public Boolean deleteBatchUnusedCoupons(GoodsTypeEnum gtype, long gid, Long batchId, List<Long> couponIds);
    
    /**
     * 查询未使用的优惠券
     * @param gtype
     * @param gid
     * @param batchId
     * @param limit
     * @return
     */
    public List<GoodsCouponDto> findUnusedCoupons(GoodsTypeEnum gtype, long gid, Long batchId, int limit);

    /**
     * 修改过期时间
     * @param gtype
     * @param acgId
     * @param batchId
     * @param startDay
     * @param endDay
     * @return
     */
    public Boolean updateValidDate(GoodsTypeEnum gtype, long acgId, long batchId, Date startDay, Date endDay);
}
