package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.PreStockPointDao;
import cn.com.duiba.goods.center.biz.entity.PreStockPointEntity;

/**
 * PreStockManualChangeDaoImpl
 */
@Repository
public class PreStockPointDaoImpl extends BaseCreditsDao implements PreStockPointDao {

	private String itemIdKey = "itemId";
	
	@Override
	public List<PreStockPointEntity> findAllByItemId(Long itemId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(itemIdKey, itemId);
		return getSqlSession().selectList(getStamentNameSpace("findAllByItemId"), paramMap);
	}

	@Override
	public void batchInsert(List<PreStockPointEntity> prePointList) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("stockPointList", prePointList);
		getSqlSession().insert(getStamentNameSpace("batchInsert"), paramMap);
	}

	@Override
	public List<Long> findAllAppIdByItemId(Long itemId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(itemIdKey, itemId);
		return getSqlSession().selectList(getStamentNameSpace("findAllAppIdByItemId"), paramMap);
	}

	@Override
	public PreStockPointEntity findAppIdAndItemId(Long appId, Long itemId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(itemIdKey, itemId);
		paramMap.put("appId", appId);
		return getSqlSession().selectOne(getStamentNameSpace("findAppIdAndItemId"), paramMap);
	}

	@Override
	public PreStockPointEntity findItemIdAndNullApp(Long itemId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(itemIdKey, itemId);
		return getSqlSession().selectOne(getStamentNameSpace("findItemIdAndNullApp"), paramMap);
	}

	@Override
	public void update(PreStockPointEntity point) {
		getSqlSession().update(getStamentNameSpace("update"), point);
	}

	@Override
	public int insert(PreStockPointEntity pointStock) {
		return getSqlSession().insert(getStamentNameSpace("insert"), pointStock);
	}

	@Override
	public List<PreStockPointEntity> findAllPointAppItem(List<Long> itemIds, Long appId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("itemIds", itemIds);
		paramMap.put("appId", appId);
		return getSqlSession().selectList(getStamentNameSpace("findAllPointAppItem"), paramMap);
	}

	@Override
	public PreStockPointEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("id", id);
		return getSqlSession().selectOne(getStamentNameSpace("find"), paramMap);
	}

}
