package cn.com.duiba.goods.center.biz.service.item;

import java.util.Date;
import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;

/**
 * 
 * ItemKeyService
 *
 */
public interface ItemKeyService {
	
	/**
	 * 查询商品封装信息
	 * 
	 * @param appItemId
	 *            开发者商品ID
	 * @param itemId
	 *            兑吧商品ID
	 * @param appId
	 *            应用ID
	 * @return
	 */
	public ItemKeyDto findItemKey(Long appItemId, Long itemId, Long appId);
	
	/**
	 * 查询商品封装信息,包含开发者删除
	 * 
	 * @param appItemId
	 *            开发者商品ID
	 * @param itemId
	 *            兑吧商品ID
	 * @param appId
	 *            应用ID
	 * @return
	 */
	public ItemKeyDto findItemKeyIncludeDeleted(Long appItemId, Long itemId, Long appId);
	
	/**
	 * 批量获取ItemKey
	 * @param appItemIds
	 * @param appId
	 * @return
	 */
	public List<ItemKeyDto> findItemKeyByAppItemIds(List<Long> appItemIds, Long appId);
	

	/**
	 * 查询当前库存
	 * 
	 * @param itemKeyDto 商品对象
	 * @return
	 */
	public Long findStock(ItemKeyDto itemKeyDto);

	/**
	 * 消耗商品库存
	 * 
	 * @param itemKeyDto 商品对象
	 * @param bizId 业务流水号
	 * @param bizSource 业务类型 ItemStockSpecifyConsumeDO.BIZ_SOURCE_{}
	 * @return
	 */
	public Boolean consumeStock(ItemKeyDto itemKeyDto, String bizId, String bizSource);
	
	/**
	 * 返还商品库存
	 * 
	 * @param itemKeyDto 商品对象
	 * @param bizId 业务流水号
	 * @param bizSource 业务类型 ItemStockSpecifyConsumeDO.BIZ_SOURCE_{}
	 * @param bizDate 业务订单创建时间
	 * @return
	 */
	public Boolean rollbackStock(ItemKeyDto itemKeyDto, String bizId, String bizSource, Date bizDate);

}
