package cn.com.duiba.goods.center.biz.service.item.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.biz.dao.AppItemExtraDao;
import cn.com.duiba.goods.center.biz.entity.AppItemExtraEntity;
import cn.com.duiba.goods.center.biz.service.item.AppItemExtraService;

/**
 * Created by xiaoxuda on 2016/12/6.
 */
@Service("appItemExtraService")
public class AppItemExtraServiceImpl implements AppItemExtraService{
    @Autowired
    private AppItemExtraDao appItemExtraDao;

    @Override
    public AppItemExtraEntity findByAppItemId(Long appItemId) {
        return appItemExtraDao.findByAppItemId(appItemId);
    }

    @Override
    public int insert(AppItemExtraEntity appItemExtra) {
        return appItemExtraDao.insert(appItemExtra);
    }

    @Override
    public int updateByAppItemId(AppItemExtraEntity appItemExtra) {
        return appItemExtraDao.updateByAppItemId(appItemExtra);
    }

    @Override
    public int deleteByAppItemId(Long appItemId) {
        return appItemExtraDao.deleteByAppItemId(appItemId);
    }

    @Override
    public int insertOrUpdateByAppItemId(AppItemExtraEntity appItemExtra) {
        AppItemExtraEntity dto = appItemExtraDao.findByAppItemId(appItemExtra.getAppItemId());
        if(dto==null){
            return appItemExtraDao.insert(appItemExtra);
        }else{
            return appItemExtraDao.updateByAppItemId(appItemExtra);
        }
    }
}
