package cn.com.duiba.goods.center.biz.bo.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.AppItemClassifyRelationDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.biz.bo.AppItemClassifyRelationBO;
import cn.com.duiba.goods.center.biz.dao.AppItemClassifyRelationDao;
import cn.com.duiba.goods.center.biz.dao.item.AppItemDao;

/**
 * Created by xiaoxuda on 2016/11/18.
 */
@Service("appItemClassifyRelationBO")
public class AppItemClassifyRelationBOImpl implements AppItemClassifyRelationBO {
    @Autowired
    private AppItemClassifyRelationDao appItemClassifyRelationDao;
    @Autowired
    private AppItemDao appItemDao;

    @Override
    public List<AppItemDto> findAppItemsWithClassifyPayLoad(Long classifyId, Long appId, String status) {
        List<AppItemClassifyRelationDto> relationList = appItemClassifyRelationDao.getByClassifyId(classifyId);

        if (relationList.isEmpty()) {
            return new ArrayList<>();
        }

        List<Long> ids = new ArrayList<>();
        Map<Long, AppItemClassifyRelationDto> map = new HashMap<>();
        for (AppItemClassifyRelationDto dto : relationList) {
            ids.add(dto.getAppItemId());
            map.put(dto.getAppItemId(), dto);
        }
        List<AppItemDto> resultList = appItemDao.findAppItemsByAppIdAndIds(appId, status, ids);
        for (AppItemDto item : resultList) {
            AppItemClassifyRelationDto aicr = map.get(item.getId());
            if (aicr != null) {
                item.setPayload(aicr.getPayload());
            }
        }
        return resultList;
    }
}
