package cn.com.duiba.goods.center.biz.bo.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.constant.PlatformCouponGoodsConstant;
import cn.com.duiba.goods.center.api.remoteservice.dto.ACGStockDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsDirectionalConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFilterConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFloorDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.goods.center.biz.bo.PCGFilterConfigBO;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.goods.center.biz.service.stock.PcgDirectionalSalesVolumeService;
import cn.com.duiba.goods.center.biz.service.stock.StockService;
import cn.com.duiba.stock.service.api.dto.StockDto;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;

/**
 * PCGFilterConfigBOImpl
 */
@Service
public class PCGFilterConfigBOImpl implements PCGFilterConfigBO{

	/**
	 * PCGIdAndPayLoad
	 */
	public static class PCGIdAndPayLoad {
		private Long pagId;
		private Integer payLoad;

		/**
		 * PCGIdAndPayLoad
		 */
		public PCGIdAndPayLoad() {

		}

		/**
		 * PCGIdAndPayLoad
		 * @param pcgId
		 * @param payLoad
		 */
		public PCGIdAndPayLoad(Long pcgId, Integer payLoad) {
			this.pagId = pcgId;
			this.payLoad = payLoad;
		}

		public Long getPagId() {
			return pagId;
		}

		public Integer getPayLoad() {
			return payLoad;
		}

	}

    @Autowired
    private PCGFilterConfigService        pCGFilterConfigService;
    @Autowired
    private PCGCategoryGoodsService       pCGCategoryGoodsService;
    @Autowired
    private PCGSellerGoodsService         pCGSellerGoodsService;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private PlatformCouponGoodsService    platformCouponGoodsService;
    @Autowired
    protected GoodsBatchService           goodsBatchService;
    @Autowired
    protected RemoteStockBackendService   remoteStockBackendService;
    @Autowired
    protected GoodsLimitRecordService     goodsLimitRecordService;
    @Autowired
    protected GoodsBatchCouponBackendBO   goodsBatchCouponBackendBO;
    @Autowired
    protected StockService stockService;
    @Autowired
    private PcgDirectionalSalesVolumeService pcgDirectionalSalesVolumeService;
    private SimpleDateFormat              sdf  = new SimpleDateFormat("yyyy.MM.dd");
    private SimpleDateFormat              sdf2 = new SimpleDateFormat("yyyyMMdd");
    
    private  static final Integer CATEGORYLISTMAX = 2;
    private Ordering<PCGCategoryEntity> categoryOrder = Ordering.natural().nullsFirst().onResultOf(new Function<PCGCategoryEntity, Integer>() {
        @Override
    	public Integer apply(PCGCategoryEntity foo) {
            return foo.getPayload();
        }
    });

    private Ordering<PCGFloorDto> dtoOrdering = Ordering.natural().nullsFirst().onResultOf(new Function<PCGFloorDto, Comparable>() {
        @Override
        public Comparable apply(PCGFloorDto pcgFloorDto) {
            return pcgFloorDto.getPayload();
        }
    });
    

    /**
     * filterGoods
     * @param pcgIds
     * @param appId
     * @return
     */
    public List<Long> filterGoods(List<Long> pcgIds, Long appId) {
        List<Long> filterGoodsIds = pCGFilterConfigService.selectPCGFilterTargetIds(appId,
                                                                                    PlatformCouponGoodsConstant.PcgFilterConfigGoodsType);
        if (!filterGoodsIds.isEmpty()) {
            Iterator<Long> ps = pcgIds.iterator();
            while (ps.hasNext()) {
                Long pcgId = ps.next();
                for (Long filterGoodsId : filterGoodsIds) {
                    // 当前商品被屏蔽，清除
                    if ((pcgId - filterGoodsId) == 0) {
                        ps.remove();
                    }
                }
            }
        }
        return pcgIds;
    }
    
    @Override
    public Page<PCGCategorySellerGoodsDto> findCategoryGoods(long appId, long categoryId, Long consumerId,
                                                             Long consumerCredits, Integer pageIndex, Integer pageSize) {
        List<Long> pcgIds = new ArrayList<>();
        // 1.查询该类目下的所有商品
        List<PCGCategoryGoodsEntity> pCGCategoryGoodsEntity = pCGCategoryGoodsService.findAllGoodsByCategory(categoryId);

        List<PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<>();
        for (PCGCategoryGoodsEntity cateGoods : pCGCategoryGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }
        pCGFilterConfigService.goodsTagsIdFilter(pcgIds, appId);
        // 2.商品进行单品黑名单过滤
        pcgIds = checkBlack(pcgIds, appId);
        // 4.放入商品信息
        Page<PCGCategorySellerGoodsDto> page = new Page<>(pageSize, pageIndex);
        if (pcgIds !=null && !pcgIds.isEmpty()) {
            page = findGoods(appId, pcgIds, consumerId, consumerCredits, pCGIdAndPayLoads, pageIndex, pageSize);
        }
        return page;
    }

    /**
     * set排序号
     * @param ppl
     * @param pcgId
     * @return
     */
    public static Integer setPayLoad(List<PCGIdAndPayLoad> ppl, Long pcgId) {
        for (PCGIdAndPayLoad p : ppl) {
            if (p.getPagId().longValue() == pcgId.longValue()) {
                return p.getPayLoad();
            }
        }
        return 0;
    }

    /**
     * 查询商品信息
     * @param appId
     * @param pcgIds
     * @param consumerId
     * @param consumerCredits
     * @param pCGIdAndPayLoads
     * @param pageIndex
     * @param pageSize
     * @return
     */
    public Page<PCGCategorySellerGoodsDto> findGoods(Long appId, List<Long> pcgIds, Long consumerId,
                                                     Long consumerCredits, List<PCGIdAndPayLoad> pCGIdAndPayLoads,
                                                     Integer pageIndex, Integer pageSize) {
        List<PCGCategorySellerGoodsDto> goodsList = new ArrayList<>();
        /*** 查询开启预分配商品列表 */
        Map<String, GoodsDirectionalConfigEntity> directionals = goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM,
                                                                                                              pcgIds);
        List<GoodsDirectionalConfigEntity> directionalList = Lists.newArrayList(directionals.values());
        Map<String, Long> saleMap = pcgDirectionalSalesVolumeService.findSaleCountTodayBatch(directionalList);
        /*** 查询数据库商品列表 */
        Map<Long, PlatformCouponGoodsEntity> pcgs = platformCouponGoodsService.findByIds(pcgIds);
        /*** 批量查询商品库存 */
        List<Long> gids = new ArrayList<>();
        for(Map.Entry<Long, PlatformCouponGoodsEntity> entry : pcgs.entrySet()){
            PlatformCouponGoodsEntity pce = entry.getValue();
        	gids.add(pce.getPcgId());
        }
        Map<Long, Long> gstockMap = new HashMap<>();
        if(!gids.isEmpty()){
            List<ACGStockDto> gstocks = goodsBatchService.findStockByGids(GoodsTypeEnum.PLATFORM, gids);
            for(ACGStockDto stock : gstocks){
                gstockMap.put(stock.getAcgId(), stock.getStock());
            }
        }
        /***批量查询库存*/
        List<Long> stockIds = new ArrayList<>();
        for (Long pcgIdKey : pcgs.keySet()) {
            GoodsDirectionalConfigEntity gdce1 = null;
            GoodsDirectionalConfigEntity gdce2 = null;
            PlatformCouponGoodsEntity pce = pcgs.get(pcgIdKey);
            // 券是未启用状态,删除状态。返回
            if (PlatformCouponGoodsConstant.PcgStatusOn != pce.getPcgStatus().intValue() || pce.getDeleted()) {
                continue;
            }
            // 开启预分配
            if (isOpen(PlatformCouponGoodsConstant.PcgDirectionalSwitches, pce.getSwitches().intValue())) {
                if (!directionals.isEmpty()) {
                    // 查询是否存在清单
                    gdce1 = directionals.get(appId + "-" + pcgIdKey);
                    // 查询是否存在共享库，共享库appId是0
                    gdce2 = directionals.get(0 + "-" + pcgIdKey);
                    // 如果券开启了库存预分配，且当前应用和共享库均不在预分配清单中则不展示；
                    if (gdce1 == null && gdce2 == null) {
                        continue;
                    }
                }
            }
            PCGCategorySellerGoodsDto psgd = new PCGCategorySellerGoodsDto();
            ObjectUtil.convert(pce, psgd);
            GoodsDirectionalConfigDto gc = new GoodsDirectionalConfigDto();
            // 设置库存
            if (gdce2 != null) {
                ObjectUtil.convert(gdce2, gc);
                if (gdce2.getStockId() != null) {
                	stockIds.add(gdce2.getStockId());
                }
            }
            // 当前商品预分配的库存
            if (gdce1 != null) {
                gc = new GoodsDirectionalConfigDto();
                ObjectUtil.convert(gdce1, gc);
                if (gdce1.getStockId() != null) {
                	stockIds.add(gdce1.getStockId());
                }
            }
        }
        Map<Long, StockDto> stockMap = stockService.findStockByStockIds(stockIds);
        for (Long pcgIdKey : pcgs.keySet()) {
            GoodsDirectionalConfigEntity gdce1 = null;
            GoodsDirectionalConfigEntity gdce2 = null;
            PlatformCouponGoodsEntity pce = pcgs.get(pcgIdKey);
            // 券是未启用状态,删除状态。返回
            if (PlatformCouponGoodsConstant.PcgStatusOn != pce.getPcgStatus().intValue() || pce.getDeleted()) {
                continue;
            }
            // 开启预分配
            if (isOpen(PlatformCouponGoodsConstant.PcgDirectionalSwitches, pce.getSwitches().intValue())) {
                if (!directionals.isEmpty()) {
                    // 查询是否存在清单
                    gdce1 = directionals.get(appId + "-" + pcgIdKey);
                    // 查询是否存在共享库，共享库appId是0
                    gdce2 = directionals.get(0 + "-" + pcgIdKey);
                    // 如果券开启了库存预分配，且当前应用和共享库均不在预分配清单中则不展示；
                    if (gdce1 == null && gdce2 == null) {
                        continue;
                    }

                }
            }
            PCGCategorySellerGoodsDto psgd = new PCGCategorySellerGoodsDto();
            ObjectUtil.convert(pce, psgd);
            GoodsDirectionalConfigDto gc = new GoodsDirectionalConfigDto();
            // 设置库存
            if (gdce2 != null) {
                ObjectUtil.convert(gdce2, gc);
                if (gdce2.getStockId() == null) {
                    gc.setStock(0L);
                } else {
                	StockDto stock = stockMap.get(gdce2.getStockId());
                	if (stock != null ) {
                        gc.setStock(stock.getStock());
                    }
                }
            }
            if (gdce1 != null) {
                gc = new GoodsDirectionalConfigDto();
                ObjectUtil.convert(gdce1, gc);
                if (gdce1.getStockId() == null) {
                    gc.setStock(0L);
                } else {
                	// 当前商品预分配的库存
                	StockDto stock = stockMap.get(gdce1.getStockId());
                	if (stock != null ) {
                        gc.setStock(stock.getStock());
                    }
                }
            }
            gc.setSales(saleMap.get(gc.getGoodsId()+"-"+gc.getId()));
            // 设置开奖预分配对象，积分展示需要调用
            psgd.setGoodsDirectionalConfigDto(gc);
            // 设置排序值
            psgd.setPayLoad(setPayLoad(pCGIdAndPayLoads, psgd.getPcgId()));
            long pcgStock = gstockMap.get(pce.getPcgId());
            psgd.setStock(pcgStock);
            goodsList.add(psgd);
        }
        return page(pageIndex, pageSize, goodsList);
    }

    @Override
    public Page<PCGCategorySellerGoodsDto> findSellerGoods(long appId, long sellerId, Long consumerId,
                                                           Long consumerCredits, Integer pageIndex, Integer pageSize) {
        List<Long> pcgIds = new ArrayList<>();
        List<PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<>();
        // 1.查询该类目下的所有商品
        List<PCGSellerGoodsEntity> pCGSellerGoodsEntity = pCGSellerGoodsService.findAllGoodsBySeller(sellerId);
        for (PCGSellerGoodsEntity cateGoods : pCGSellerGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }
        pCGFilterConfigService.goodsTagsIdFilter(pcgIds, appId);
        // 2.商品进行单品黑名单过滤
        pcgIds = checkBlack(pcgIds, appId);
        Page<PCGCategorySellerGoodsDto> page = new Page<>(pageSize, pageIndex);
        // 3.放入商品信息
        if (!pcgIds.isEmpty()) {
            page = findGoods(appId, pcgIds, consumerId, consumerCredits, pCGIdAndPayLoads, pageIndex, pageSize);
        }
        return page;
    }
    
    /**
     * 批量验证商品黑名单
     * @param pcgIds
     * @param appId
     * @return
     */
    @Override
    public List<Long> checkBlack(List<Long> pcgIds,Long appId){
    	List<PCGCategoryEntity> cates=pCGFilterConfigService.findCategoryFilterList(appId);
    	Set<Long> catSet=new HashSet<>();
    	for(PCGCategoryEntity c:cates){
    		catSet.add(c.getId());
    	}
    	
    	List<PCGSellerEntity> sellers=pCGFilterConfigService.findSellerFilterList(appId);
    	Set<Long> sellerSet=new HashSet<>();
    	for(PCGSellerEntity e:sellers){
    		sellerSet.add(e.getId());
    	}
    	
    	Map<Long,List<PCGFilterConfigDto>> belongs= pCGFilterConfigService.findFilterCounponBelongs(catSet,sellerSet);
    	
    	List<PlatformCouponGoodsEntity> goodss=pCGFilterConfigService.findGoodsFilterList(appId);
    	boolean flag = true;
        Iterator<Long> ps = pcgIds.iterator();
        while (ps.hasNext()) {
        	flag = true;//标识商品是否已经加入黑名单
            long pcgId = ps.next();
            for (PlatformCouponGoodsEntity goods : goodss) {
                // 当前商品被屏蔽，清除
                if ((pcgId - goods.getPcgId()) == 0) {
                    ps.remove();
                    flag = false;
                    break;
                }
            }
            if(belongs !=null &&  !belongs.isEmpty()){
            	List<PCGFilterConfigDto> pcs =  belongs.get(pcgId);
            	if(flag && pcs !=null && !pcs.isEmpty()){
            		for(PCGFilterConfigDto f:belongs.get(pcgId)){
            			if(f.getType()==PlatformCouponGoodsConstant.PcgFilterConfigCategoryType){
            				if(catSet.contains(f.getTargetId())){
            					//商品所属类目在黑名单中
            					ps.remove();
            					break;
            				}
            			}else if(f.getType()==PlatformCouponGoodsConstant.PcgFilterConfigSellerType){
            				if(sellerSet.contains(f.getTargetId())){
            					//商品在所属品牌的黑名单中
            					ps.remove();
            					break;
            				}
            			}
            		}
            	}
            }
        }
        return pcgIds;
    }

    /**
     * isOpen
     * @param bit
     * @param switches
     * @return
     */
    public static boolean isOpen(int bit, int switches) {
        int v = 1 << bit;
        int ret = switches & v;
        return ret != 0;
    }

    /**
     * Page
     * @param pageIndex
     * @param pageSize
     * @param t
     * @return
     */
    public <T extends Comparable<? super T>> Page<T> page(Integer pageIndex, Integer pageSize, List<T> t) {
        Page<T> page = new Page<>(pageSize, pageIndex);
        List<T> newList = new ArrayList<>();
        page.setList(newList);
        if (t.isEmpty()) {
            return page;
        }
        Collections.sort(t);
        int total = t.size();
        int index = 0;// 循环索引开始
        // 大于两页
        if (pageIndex > 1) {
            index = (pageIndex - 1) * pageSize;
        }
        int totalPages = total % pageSize == 0 ? total / pageSize : (total / pageSize + 1);
        // 索引页必须小于总的页数
        if (pageIndex <= totalPages) {
            if (pageIndex == 1) {
                pageIndex = 0;
            }
            for (int i = index; i < total; i++) {
                // 只取20条，满足跳出
                if (pageSize * (pageIndex + 1) == i) {
                    break;
                }
                newList.add(t.get(i));
            }
        }
        page.setList(newList);
        page.setTotalPages(totalPages);
        page.setPageSize(pageSize);
        page.setCurrent(pageIndex);
        return page;
    }



    @Override
    public List<PCGFloorDto> findFloorPcgByAppId(Long appId, Integer size) {

        List<PCGCategorySellerGoodsDto> categoryGoodsList = pCGFilterConfigService.selectPCGCategoryGoodsList(appId);
        List<PCGCategorySellerGoodsDto> sellerGoodsList = pCGFilterConfigService.selectPCGSellerGoodsList(appId);
        sellerGoodsList.removeAll(categoryGoodsList);
        sellerGoodsList.addAll(categoryGoodsList);
        Collections.sort(sellerGoodsList);

        List<Long> pcgIds = new ArrayList<>();
        for (PCGCategorySellerGoodsDto it : sellerGoodsList) {
            if(pcgIds.size()<size) pcgIds.add(it.getPcgId());
            else break;
        }
        sellerGoodsList = sellerGoodsList.subList(0,pcgIds.size());

        Map<String, GoodsDirectionalConfigEntity> directionals = goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM, pcgIds);
        Map<Long, PlatformCouponGoodsEntity> pcgs = platformCouponGoodsService.findByIds(pcgIds);

        List<PCGFloorDto> goodsList = new ArrayList<>();

        for (PCGCategorySellerGoodsDto it : sellerGoodsList) {
            PlatformCouponGoodsEntity pce = pcgs.get(it.getPcgId());
            if (!canShow(directionals, pce, appId)) {
                continue;
            }
            PCGFloorDto psgd = new PCGFloorDto();
            ObjectUtil.convert(pce, psgd);
            psgd.setMinPrice(getMinPrice(directionals, pce, appId));
            setGoodsBatch(psgd, it.getPcgId());
            goodsList.add(psgd);
        }
        
        return goodsList;
    }

    @Override
    public List<PCGFloorDto> findAllPcg4Floor(Long appId, String appTags) {
        List<PCGCategoryEntity> allCategoryList = pCGCategoryGoodsService.findAll();
        List<Long> categoryIds = pCGFilterConfigService.selectPCGFilterTargetIds(appId,PlatformCouponGoodsConstant.PcgFilterConfigCategoryType);

        Set<Long> categoryFilterIds = Sets.newHashSet(categoryIds);
        List<PCGCategoryEntity> categoryList = Lists.newArrayList();
        List<Long> cids = Lists.newArrayList();
        for(PCGCategoryEntity it:allCategoryList){
            if(categoryFilterIds.contains(it.getId())){
                continue;
            }
            cids.add(it.getId());
            categoryList.add(it);
        }
        if(categoryList.isEmpty()){
            return Collections.emptyList();
        }
        categoryList = categoryOrder.sortedCopy(categoryList);

        /*** 查询App分类下的所有商品 */
        List<PCGCategoryGoodsEntity> pCGCategoryGoodsList = pCGCategoryGoodsService.findAllGoodsByCateIds(cids);
        if(pCGCategoryGoodsList.isEmpty()){
            return Collections.emptyList();
        }

        Map<Long,PCGCategoryGoodsEntity> pcgTable = Maps.newHashMap();
        List<Long> pcgIds = new ArrayList<>();
        for (PCGCategoryGoodsEntity cateGoods : pCGCategoryGoodsList) {
            pcgIds.add(cateGoods.getPcgId());
            pcgTable.put(cateGoods.getPcgId(),cateGoods);
        }
        List<PlatformCouponGoodsEntity> allList = platformCouponGoodsService.findListByIds(pcgIds);

        allList = pCGFilterConfigService.goodsTagsFilter(allList,appTags);
        allList = goodsStateFilter(appId,allList);

        ArrayListMultimap<Long,PCGFloorDto> allMap = ArrayListMultimap.create();
        for(PlatformCouponGoodsEntity it:allList){
            PCGCategoryGoodsEntity res = pcgTable.get(it.getPcgId());

            PCGFloorDto dto = new PCGFloorDto();
            dto.setPcgId(it.getPcgId());
            dto.setPayload(res.getPayload());
            dto.setCategoryId(res.getCategoryId());
            dto.setBackgroundColor(it.getBackgroundColor());
            dto.setInterestDesc(it.getInterestDesc());
            dto.setInterestPrice(it.getInterestPrice());
            dto.setIconImage(it.getIconImage());
            dto.setTitle(it.getTitle());
            dto.setSubtitle(it.getSubtitle());
            dto.setMinPrice(it.getMinPrice());
            dto.setThumbnailImage(it.getThumbnailImage());
            allMap.put(res.getCategoryId(),dto);
        }
        List<PCGFloorDto> newList = Lists.newArrayList();
        for(PCGCategoryEntity category:categoryList){
            if(!allMap.containsKey(category.getId())){
                continue;
            }
            List<PCGFloorDto> list = allMap.get(category.getId());
            list = dtoOrdering.sortedCopy(list);
            if(list.size()>CATEGORYLISTMAX){
                list = Lists.newArrayList(list.get(0),list.get(1));
            }
            newList.addAll(list);
        }
        setGoodsBatchs(newList);
        return newList;
    }

    private List<PlatformCouponGoodsEntity> goodsStateFilter(Long appId,List<PlatformCouponGoodsEntity> allList) {
        List<PlatformCouponGoodsEntity> newList = Lists.newArrayList();
        List<Long> filterIds = pCGFilterConfigService.findGoodsFilterIdList(appId);
        Set<Long> filterSet = Sets.newHashSet(filterIds);
        List<Long> needDirectionalIds = Lists.newArrayList();
        for(PlatformCouponGoodsEntity it:allList){
            if(PlatformCouponGoodsConstant.PcgStatusOn != it.getPcgStatus() || it.getDeleted()){
                continue;
            }
            if(filterSet.contains(it.getPcgId())){
                continue;
            }
            if(isOpen(PlatformCouponGoodsConstant.PcgDirectionalSwitches, it.getSwitches().intValue())){
                needDirectionalIds.add(it.getPcgId());
            }
            newList.add(it);
        }

        Map<String, GoodsDirectionalConfigEntity> directionals = goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM, needDirectionalIds);

        List<PlatformCouponGoodsEntity> returnList = Lists.newArrayList();
        for(PlatformCouponGoodsEntity it:newList){
            if (isOpen(PlatformCouponGoodsConstant.PcgDirectionalSwitches, it.getSwitches().intValue())) {
                // 查询是否存在清单
                GoodsDirectionalConfigEntity gdce1 = directionals.get(appId + "-" + it.getPcgId());
                GoodsDirectionalConfigEntity gdce2 = directionals.get(0 + "-" + it.getPcgId());
                // 如果券开启了库存预分配，且当前应用和共享库均不在预分配清单中则不展示；
                if (gdce1 == null && gdce2 == null) {
                    continue;
                }
            }
            returnList.add(it);
        }
        return returnList;
    }

    /**
     * 填充开始结束时间
     * @param psgd
     * @param pcgId
     */
    private void setGoodsBatch(PCGFloorDto psgd, Long pcgId) {
        List<GoodsBatchDto> goodsBatchs = goodsBatchCouponBackendBO.findBatchs(GoodsTypeEnum.PLATFORM, pcgId);
        String currentTime = sdf2.format(new Date());
        for (GoodsBatchDto goodsBatch : goodsBatchs) {
            //当前批次有效，3：已使用完，4：已经删除，当前批次发放的券库存大于0 且 必须是有效日期
            if (goodsBatch.getStatus() != null && goodsBatch.getStatus() != 3 && goodsBatch.getStatus() != 4 &&
                    goodsBatch.getStock() > 0 && Integer.parseInt(sdf2.format(goodsBatch.getEndDay())) >= Integer.parseInt(currentTime)) {
                psgd.setStartDate(sdf.format(goodsBatch.getStartDay()));
                psgd.setEndDate(sdf.format(goodsBatch.getEndDay()));
                //设置1分钟缓存
                break;
            }
        }
        //如果全部批次都已发放完则展示最后添加的那个券码批次的有效期
        if (!goodsBatchs.isEmpty() && StringUtils.isBlank(psgd.getEndDate())) {
            psgd.setStartDate(sdf.format(goodsBatchs.get(goodsBatchs.size() - 1).getStartDay()));
            psgd.setEndDate(sdf.format(goodsBatchs.get(goodsBatchs.size() - 1).getEndDay()));
            //设置1分钟缓存
        }
    }
    
    /**
     * 查询批次信息，无券码密码
     * @param dtos
     * @return
     */
	private List<PCGFloorDto> setGoodsBatchs(List<PCGFloorDto> dtos) {
		List<Long> gids = new ArrayList<>();
		for (PCGFloorDto dto : dtos) {
			gids.add(dto.getPcgId());
		}
		if (gids.isEmpty()) {
			return dtos;
		}
		List<GoodsBatchDto> goodsBatchs = goodsBatchService.findBatchsNoCode(GoodsTypeEnum.PLATFORM, gids);
		for (PCGFloorDto psgd : dtos) {
			String currentTime = sdf2.format(new Date());
			for (GoodsBatchDto goodsBatch : goodsBatchs) {
                //当前批次有效，3：已使用完，4：已经删除，当前批次发放的券库存大于0 且 必须是有效日期
                if (goodsBatch.getStatus() != null && goodsBatch.getStatus() != 3 && goodsBatch.getStatus() != 4 &&
                        goodsBatch.getStock() > 0 && Integer.parseInt(sdf2.format(goodsBatch.getEndDay())) >= Integer.parseInt(currentTime)) {
					psgd.setStartDate(sdf.format(goodsBatch.getStartDay()));
					psgd.setEndDate(sdf.format(goodsBatch.getEndDay()));
					break;
				}
			}
			// 如果全部批次都已发放完则展示最后添加的那个券码批次的有效期
			if (!goodsBatchs.isEmpty() && StringUtils.isBlank(psgd.getEndDate())) {
				psgd.setStartDate(sdf.format(goodsBatchs.get(goodsBatchs.size() - 1).getStartDay()));
				psgd.setEndDate(sdf.format(goodsBatchs.get(goodsBatchs.size() - 1).getEndDay()));
			}
		}
		return dtos;
	}
    
    

    /**
     * 是否可以展示
     * @param directionals
     * @param entity
     * @param appId
     * @return
     */
    private boolean canShow(Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Long appId) {
        // 券是未启用状态,删除状态。返回
        if (PlatformCouponGoodsConstant.PcgStatusOn != entity.getPcgStatus() || entity.getDeleted()) {
            return false;
        }
        // 没有开启预分配
        if (!isOpen(PlatformCouponGoodsConstant.PcgDirectionalSwitches, entity.getSwitches().intValue())) {
            return true;
        }
        GoodsDirectionalConfigEntity directionalConfig = getGoodsDirectionalConfig(directionals, entity, appId);
        return directionalConfig != null;
    }

    /**
     * 获取预分配关系
     * @param directionals
     * @param entity
     * @param appId
     * @return
     */
    private GoodsDirectionalConfigEntity getGoodsDirectionalConfig(Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Long appId) {
        // 开启预分配
        if (!isOpen(PlatformCouponGoodsConstant.PcgDirectionalSwitches, entity.getSwitches().intValue())) {
            return null;
        }
        if (directionals.isEmpty()) {
            return null;
        }
        GoodsDirectionalConfigEntity gdce1 = null;
        GoodsDirectionalConfigEntity gdce2 = null;
        // 查询是否存在清单
        gdce1 = directionals.get(appId + "-" + entity.getPcgId());
        // 查询是否存在共享库，共享库appId是0
        gdce2 = directionals.get(0 + "-" + entity.getPcgId());
        // 如果券开启了库存预分配，且当前应用和共享库均不在预分配清单中则不展示；
        if (gdce1 == null && gdce2 == null) {
            return null;
        }
        if (gdce1 != null) {
            return gdce1;
        } else {
            return gdce2;
        }
    }

    /**
     * 计算积分
     * @param duibaPrice
     * @param creditsRate
     * @return
     */
    private Long getCredits(Integer duibaPrice, Long creditsRate) {
        if (duibaPrice == null || creditsRate == null) {
            return null;
        }
        long credits = (long) Math.ceil(duibaPrice * creditsRate / 100.0);
        if (credits < 1L) {
            credits = 1L;
        }
        return credits;
    }

    /**
     * 计算最小积分
     * @param directionals
     * @param entity
     * @param appId
     * @return
     */
    private Integer getMinPrice(Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Long appId) {
        if (!isOpen(PlatformCouponGoodsConstant.PcgDirectionalSwitches, entity.getSwitches().intValue())) {
            return entity.getMinPrice();
        }
        GoodsDirectionalConfigEntity directionalConfig = getGoodsDirectionalConfig(directionals, entity, appId);
        if (directionalConfig == null) {
            return entity.getMinPrice();
        }
        return directionalConfig.getMinPrice() != null ? directionalConfig.getMinPrice() : entity.getMinPrice();
    }

    /**
     * 获取库存, 库存实际值和预分配的值取较小值
     * @param directionals
     * @param entity
     * @param appId
     * @return
     */
    private Long getStock(Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Long appId) {
        // 查询商品本身库存
        long pcgStock = goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, entity.getPcgId());
        if (pcgStock == 0) {
            return 0L;
        }
        if (!isOpen(PlatformCouponGoodsConstant.PcgDirectionalSwitches, entity.getSwitches().intValue())) {
            return pcgStock;
        }
        // 开启预分配
        long preStock = 0;
        GoodsDirectionalConfigEntity directionalConfig = getGoodsDirectionalConfig(directionals, entity, appId);
        if (directionalConfig == null) {
            return 0L;
        }
        DubboResult<Long> result = remoteStockBackendService.find(directionalConfig.getStockId());
        if (result != null && result.isSuccess()) {
            if (result.getResult() != null) {
                preStock = result.getResult();
            }
        }
        return Math.min(pcgStock, preStock);

    }
}
