package cn.com.duiba.goods.center.biz.bo.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;

import java.util.List;

/**
 * Created by liuyao on 2016/11/16.
 */
public interface ItemKeyBo {
    /**
     * 获取首页商品区或者全部兑换项展示的商品
     * @param appId
     * @return
     */
    List<ItemKeyDto> findHomeItemKeyCacheList(Long appId);

    /**
     * 根据appId查询要在首页展示的商品
     * @param appId
     * @return
     */
    List<ItemKeyDto> findHomeItemKeyList(Long appId);
    
    /**
     * 根据AppItem集合生成itemKey
     * @param appItems
     * @return
     */
    List<ItemKeyDto> getBatchItemKeyByAppItem(List<AppItemDto> appItems, Long appId);

    /**
     * 将appItemList转化成ItemKeyDto列表
     * @param appItemList
     * @return
     */
    List<ItemKeyDto> transformAppItemList(List<AppItemDto> appItemList);

    /**
     * 根据id批量查询商品项，包含在分类中的权重及优惠券库存
     * @param appItemIds
     * @return
     */
    List<ItemKeyDto> getBatchItemKeyByAppItemIds(List<Long> appItemIds);
    /**
     * 将appItemDto转化成ItemKeyDto列表
     * @param appItem
     * @return
     */
    ItemKeyDto transformAppItem(AppItemDto appItem);

    /**
     * 构造自动推荐列表
     * @param itemDtoList
     * @return
     */
    List<ItemKeyDto> transformItemList(List<ItemDto> itemDtoList);
    /**
     * 构造自动推荐ItemKey
     * @param item
     * @return
     */
    ItemKeyDto transformItem(ItemDto item);


    /**
     * 根据id查询商品项，包含在分类中的权重及优惠券库存
     * @param appItemId
     * @return
     */
    ItemKeyDto getItemKey(Long appItemId);

    /**
     * 根据appId和itemId查询商品项，包含在分类重的权重及优惠券库存
     * @param appId
     * @param itemId
     * @return
     */
    ItemKeyDto getItemKey(Long appId,Long itemId);


}
