package cn.com.duiba.goods.center.biz.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import cn.com.duiba.goods.center.api.remoteservice.constant.CacheConstants;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;

/**
 * Created by liuyao on 2016/11/16.
 * 缓存有问题
 */
@Component
public class EventHomeCache implements InitializingBean{
    private static Logger log = LoggerFactory.getLogger(EventHomeCache.class);

    @Resource(name="stringRedisTemplate03")
    private AdvancedCacheClient advancedCacheClient;
    @Resource(name="stringRedisTemplate03")
    private StringRedisTemplate stringRedisTemplate03;
    @Autowired
    private AppItemService appItemService;
    @Autowired
    private ItemService itemService;
    @Resource
    private ScheduledExecutorService es;

    //兑吧兑换项，忽略刷新缓存的ID
    private static final List<Long> noRefreshList = Arrays.asList(191L);
    private static volatile Set<Long> enableAppIds = new HashSet<>();

    private static volatile Set<Long> appIdsSet = Collections.synchronizedSet(new HashSet<Long>());
    private static volatile Set<Long> itemIdsSet = Collections.synchronizedSet(new HashSet<Long>());
    private static volatile Set<Long> appItemIdsSet = Collections.synchronizedSet(new HashSet<Long>());

    private static volatile Set<Long> itemRemainingSet=Collections.synchronizedSet(new HashSet<Long>());
    private static volatile Set<Long> appItemRemainingSet=Collections.synchronizedSet(new HashSet<Long>());
    
    
    
	private static volatile Set<String> APPITEM_CACHE = Collections.synchronizedSet(new HashSet<String>());
    
    static AtomicBoolean init = new AtomicBoolean();
    
    public void clearAppItemCache(String key){
    	APPITEM_CACHE.add(key);
    }

    /**
     * invalidApp
     * @param appId
     */
    public void invalidApp(Long appId) {
        appIdsSet.add(appId);
    }

    /**
     * invalidItem
     * @param itemId
     */
    public void invalidItem(Long itemId) {
        itemIdsSet.add(itemId);
    }

    /**
     * invalidItemRemaining
     * @param itemId
     */
    public void invalidItemRemaining(Long itemId) {
        itemRemainingSet.add(itemId);
    }

    /**
     * invalidAppItem
     * @param appItemId
     */
    public void invalidAppItem(Long appItemId) {
        appItemIdsSet.add(appItemId);
    }

    /**
     * invalidAppItemRemaining
     * @param appItemId
     */
    public void invalidAppItemRemaining(Long appItemId) {
        appItemRemainingSet.add(appItemId);
    }

    /**
     * invalidAppItem
     * @param appItemIds
     */
    public void invalidAppItem(List<Long> appItemIds) {
        appItemIdsSet.addAll(appItemIds);
    }

    /**
     * invalidRelationActivity
     * @param relationId
     * @param type
     */
    public void invalidRelationActivity(Long relationId, Integer type) {
        List<Long> appIds = appItemService.findAppIdsByInActivityId(relationId, type);
        if (appIds != null && !appIds.isEmpty()) {
            appIdsSet.addAll(appIds);
        }
    }

    /**
     * invalidRelationActivity
     * @param relationId
     */
    public void invalidRelationActivity(Long relationId) {
        List<Long> appIds = appItemService.findAppIdsByActivityId(relationId);
        if (appIds != null && !appIds.isEmpty()) {
            appIdsSet.addAll(appIds);
        }
    }

    /**
     * 更新memchached的时间戳
     * @param appId
     */
    public void updateAppTimestamp(Long appId){
        try {
            String cacheKey = CacheConstants.MS_HOME_ITEM + "-" + appId;
            advancedCacheClient.set(cacheKey, System.currentTimeMillis(), 1,TimeUnit.HOURS);
        } catch (Exception e) {
            log.error("invalidAppHomeItemKeyCache error:", e);
        }
    }
    /**
     * 获取app最后更新的时间戳
     * @param appId
     * @return
     */
    public Long getAppTimestamp(Long appId){
        String cacheKey = CacheConstants.MS_HOME_ITEM + "-" + appId;
        return advancedCacheClient.get(cacheKey);
    }

    /**
     * init
     */
    private void init() {
        if (init.compareAndSet(false, init.get())) {
            es.scheduleWithFixedDelay(new Runnable() {
                private void process(){
                    Set<Long> appIds = advancedCacheClient.get(CacheConstants.DEVELOPER_CENTER_ENABLE_APPIDS);
                    if(appIds!=null && !appIds.isEmpty()){
                        enableAppIds.addAll(appIds);

                    }
                }
                @Override
                public void run() {
                    try {
                        process();
                    } catch (Exception e) {
                        log.error("schedule run error",e);
                    }
                }
            }, 0, 1, TimeUnit.MINUTES);
            
            
            es.scheduleWithFixedDelay(new Runnable() {
                @Override
                public void run() {
					if(!APPITEM_CACHE.isEmpty()){
						Set<String> temp = APPITEM_CACHE;
						APPITEM_CACHE = Collections.synchronizedSet(new HashSet<String>());
						log.warn("clear appItemCache size:"+temp.size());
						stringRedisTemplate03.delete(temp);
					}
                }
            }, 1000, 200, TimeUnit.MILLISECONDS);


            es.scheduleWithFixedDelay(new Runnable() {
                private void process(){
                    Set<Long> tempItemIds=itemIdsSet;
                    Set<Long> tempAppItemIds=appItemIdsSet;
                    Set<Long> tempAppIds=appIdsSet;
                    Set<Long> tempItemRemaining=itemRemainingSet;
                    Set<Long> tempAppItemRemaining=appItemRemainingSet;

                    itemIdsSet=Collections.synchronizedSet(new HashSet<Long>());
                    appItemIdsSet=Collections.synchronizedSet(new HashSet<Long>());
                    appIdsSet=Collections.synchronizedSet(new HashSet<Long>());

                    itemRemainingSet=Collections.synchronizedSet(new HashSet<Long>());
                    appItemRemainingSet=Collections.synchronizedSet(new HashSet<Long>());

                    if(!tempAppItemRemaining.isEmpty()){
                        List<AppItemEntity> ais=appItemService.findByIds(new ArrayList<Long>(tempAppItemRemaining));
                        for(AppItemEntity ai:ais){
                            if(ai.getRemaining()!=null && ai.getRemaining()<=0){
                                tempAppIds.add(ai.getAppId());
                            }
                        }
                    }

                    if(!tempItemRemaining.isEmpty()){
                        List<ItemEntity> items=itemService.findByIds(new ArrayList<Long>(tempItemRemaining));
                        for(ItemEntity item:items){
                            if(item.getRemaining()!=null && item.getRemaining()<=0){
                                tempItemIds.add(item.getId());
                            }
                        }
                    }

                    if(!tempItemIds.isEmpty()){
                        tempItemIds.removeAll(noRefreshList);
                        if(!tempItemIds.isEmpty()){
                            List<Long> itemAppIds = appItemService.findAppIdByItemIds(new ArrayList<Long>(tempItemIds));
                            tempAppIds.addAll(itemAppIds);
                        }
                    }
                    if(!tempAppItemIds.isEmpty()){
                        List<Long> appItemAppIds = appItemService.findAppIdsByIds(new ArrayList<Long>(tempAppItemIds));
                        tempAppIds.addAll(appItemAppIds);
                    }


                    int temp = 0;
                    for (Long appId : tempAppIds) {
                        if(enableAppIds.contains(appId)){
                            updateAppTimestamp(appId);
                            temp ++;
                        }
                    }
                    warnLog(temp, tempItemIds, tempAppItemIds);
                }
                @Override
                public void run() {
                    try {
                        process();
                    } catch (Exception e) {
                        log.error("schedule run error",e);
                    }
                }
            }, 1000, 200, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        init();
    }

    /**
     * warnLog
     * @param appNum
     * @param item
     * @param appItem
     */
    private void  warnLog(int appNum, Set<Long> item, Set<Long> appItem) {
        if(appNum > 100){
            StringBuffer itemIds = new StringBuffer("[");
            for (Long id : item) {
                itemIds.append(id).append(",");
            }
            itemIds.append("]");

            StringBuffer appItemIds = new StringBuffer("[");
            for (Long id : appItem) {
                appItemIds.append(id).append(",");
            }
            appItemIds.append("]");

            log.warn("refresh homeCache warn : app="+appNum+" itemIds="+itemIds.toString()+" appItemIds="+appItemIds.toString());
        }
    }
}
