/**
 * Project Name:goods-center-biz
 * File Name:GoodLimitRecordDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年6月28日上午10:50:32
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao;

import java.util.List;

import cn.com.duiba.goods.center.biz.entity.GoodsLimitRecordEntity;

/**
 * ClassName:GoodLimitRecordDao <br/>
 * Date:     2016年6月28日 上午10:50:32 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface GoodsLimitRecordDao {
    
	/**
	 * selectByCondition
	 * @param gtype
	 * @param gid
	 * @param consumerId
	 * @return
	 */
    public GoodsLimitRecordEntity selectByCondition(int gtype,long gid,long consumerId);
    
    /**
     * insertRecord
     * @param gtype
     * @param gid
     * @param consumerId
     * @return
     */
    public int insertRecord(int gtype,long gid,long consumerId);
    
    /**
     * updateIncreament
     * @param gtype
     * @param gid
     * @param consumerId
     * @return
     */
    public int updateIncreament(int gtype,long gid,long consumerId);
    
    /**
     * updateRollback
     * @param gtype
     * @param gid
     * @param consumerId
     * @return
     */
    public int updateRollback(int gtype,long gid,long consumerId);

    /**
     * selectCounts
     * @param gtype
     * @param gids
     * @param consumerId
     * @return
     */
	public List<GoodsLimitRecordEntity> selectCounts(int gtype,
			List<Long> gids, long consumerId);

	/**
	 * selectCounts
	 * @param gtype
	 * @param gid
	 * @param consumerId
	 * @return
	 */
    GoodsLimitRecordEntity selectOne(int gtype, Long gid, long consumerId);
}

