/**
 * Project Name:goods-center-biz
 * File Name:PCGCategoryGoodsDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年5月26日下午5:41:29
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao;

import java.util.List;

import cn.com.duiba.goods.center.biz.entity.PCGCategoryGoodsEntity;

/**
 * ClassName:PCGCategoryGoodsDao <br/>
 * Date:     2016年5月26日 下午5:41:29 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface PCGCategoryGoodsDao {
    
	/**
	 * selectMaxPayloadByCategory
	 * @param category
	 * @return
	 */
    int selectMaxPayloadByCategory(long category);

    /**
     * insertGoods2Category
     * @param pcgId
     * @param categoryId
     * @param payload
     * @return
     */
    int insertGoods2Category(long pcgId,long categoryId,int payload);
    
    /**
     * deleteGoods2Category
     * @param pcgId
     * @param categoryId
     * @return
     */
    int deleteGoods2Category(long pcgId,long categoryId);
    
    /**
     * deleteCategoryRelation
     * @param categoryId
     * @return
     */
    int deleteCategoryRelation(long categoryId);
    
    /**
     * deleteGoodsRelation
     * @param pcgId
     * @return
     */
    int deleteGoodsRelation(long pcgId);
    
    /**
     * selectByCategory
     * @param categoryId
     * @return
     */
    List<PCGCategoryGoodsEntity> selectByCategory(long categoryId);
    
    /**
     * selectByGoods
     * @param pcgId
     * @return
     */
    List<PCGCategoryGoodsEntity> selectByGoods(long pcgId);
    
    /**
     * updatePayload
     * @param categoryId
     * @param pcgId
     * @param payload
     * @return
     */
    int updatePayload(long categoryId,long pcgId,int payload);

    /**
     * selectAllGoodsByCateIds
     * @param catIds
     * @return
     */
	List<PCGCategoryGoodsEntity> selectAllGoodsByCateIds(List<Long> catIds);
}

