package cn.com.duiba.goods.center.biz.dao.impl;

import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.api.remoteservice.constant.DevCustomizedConstants;
import cn.com.duiba.goods.center.api.remoteservice.dto.AppItemClassifyDto;
import cn.com.duiba.goods.center.biz.dao.AppItemClassifyDao;
import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;

/**
 * Created by xiaoxuda on 2016/11/17.
 */
@Repository("appItemClassifyDao")
public class AppItemClassifyDaoImpl extends BaseCreditsDao implements AppItemClassifyDao {
    
	@Override
    public AppItemClassifyDto find(Long id) {
        return getSqlSession().selectOne(getStamentNameSpace("find"),id);
    }

	@Override
	public Integer findMaxPayload(Long classifyId) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("classifyId", classifyId);
		map.put("topStart", DevCustomizedConstants.ITEM_TOP_START);
		return getSqlSession().selectOne(getStamentNameSpace("findMaxPayload"), map);	
	}

	@Override
	public Integer updatePayload(Long appItemId, Long classifyId, Integer payload) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("appItemId", appItemId);
		map.put("classifyId", classifyId);
		map.put("payload", payload);
		return getSqlSession().update(getStamentNameSpace("updatePayload"), map);
	}
}
