package cn.com.duiba.goods.center.biz.dao.item;

import java.util.List;
import java.util.Map;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AmbExpressTemplateDto;

/**
 * 加钱购模版
 */
public interface AmbExpressTemplateDAO {

	/**
	 * 根据ID查询
	 * 
	 * @param id
	 * @return
	 */
	public AmbExpressTemplateDto find(Long id);

	/**
	 * 新增记录
	 * 
	 * @param entity
	 * @return
	 */
	public void insert(AmbExpressTemplateDto entity);

	/**
	 * 更新记录
	 * 
	 * @param entity
	 */
	public int update(AmbExpressTemplateDto entity);

	/**
	 * 分页查询
	 * 
	 * @param params
	 * @return
	 */
	public List<AmbExpressTemplateDto> findPageList(Map<String, Object> params);

	/**
	 * 统计条数
	 * 
	 * @param params
	 * @return
	 */
	public long findPageCount(Map<String, Object> params);

	/**
	 * 根据模版ID删除
	 * 
	 * @param id
	 */
	public int deleteTemplateById(Long id);

	/**
	 * 根据APPID和TYPE查询
	 * 
	 * @param appId
	 * @param type
	 */
	public List<AmbExpressTemplateDto> findByAppIdAndType(Long appId, String type);

	/**
	 * 根据APPID和name查询
	 * 
	 * @param appId
	 * @param name
	 */
	public List<AmbExpressTemplateDto> findByAppIdAndName(Long appId, String name);

}
