package cn.com.duiba.goods.center.biz.dao.item;

import java.util.List;

import cn.com.duiba.goods.center.biz.entity.PreStockEntity;

/**
 * 
 * PreStockDao
 *
 */
public interface PreStockDao {

	/**
	 * find
	 * @param id
	 * @return
	 */
	public PreStockEntity find(Long id);
	
	/**
	 * findByPointId
	 * @param pointId
	 * @return
	 */
	public PreStockEntity findByPointId(Long pointId);
	
	/**
	 * newStock
	 * @param stock
	 * @return
	 */
	public PreStockEntity newStock(PreStockEntity stock);
	
	/**
	 * addQuantity
	 * @param stockId
	 * @param quantity
	 * @return
	 */
	public boolean addQuantity(Long stockId, long quantity);
	
	/**
	 * reduceQuantity
	 * @param stockId
	 * @param quantity
	 * @return
	 */
	public boolean reduceQuantity(Long stockId, long quantity);
	
	/**
	 * lock4update
	 * @param stockId
	 * @return
	 */
	public PreStockEntity lock4update(Long stockId);
	
	/**
	 * findAllByPointIds
	 * @param pointIds
	 * @return
	 */
	public List<PreStockEntity> findAllByPointIds(List<Long> pointIds);
	
}
