package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AmbExpressTemplateOptionDto;
import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.AmbExpressTemplateOptionDAO;

/**
 * 加钱购运费模版选项
 */
@Repository
public class AmbExpressTemplateOptionDAOImpl extends BaseCreditsDao implements AmbExpressTemplateOptionDAO {

	@Override
	public AmbExpressTemplateOptionDto find(Long id) {
		return getSqlSession().selectOne(getStamentNameSpace("find"), id);
	}

	@Override
	public void insert(AmbExpressTemplateOptionDto entity) {
		getSqlSession().insert(getStamentNameSpace("insert"), entity);
	}

	@Override
	public int update(AmbExpressTemplateOptionDto entity) {
		return getSqlSession().update(getStamentNameSpace("update"), entity);
	}

	@Override
	public List<AmbExpressTemplateOptionDto> findByTemplateId(Long expressTemplateId) {
		return getSqlSession().selectList(getStamentNameSpace("findByTemplateId"), expressTemplateId);
	}

	@Override
	public List<AmbExpressTemplateOptionDto> findByTemplateIds(List<Long> ids) {
		if (ids.isEmpty()) {
			return Collections.emptyList();
		}
		return getSqlSession().selectList(getStamentNameSpace("findByTemplateIds"), ids);
	}

	@Override
	public int deleteOptionByTemplateId(Long expressTemplateId) {
		return getSqlSession().update(getStamentNameSpace("deleteOptionByTemplateId"), expressTemplateId);
	}

	@Override
	public int batchInsert(List<AmbExpressTemplateOptionDto> ambExpressTemplateOptionDtos) {
		return getSqlSession().insert(getStamentNameSpace("batchInsert"), ambExpressTemplateOptionDtos);
	}

}
