package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.AppBannerDao;

/**
 * AppBannerDao
 */
@Service
public class AppBannerDaoImpl extends BaseCreditsDao implements AppBannerDao {

	@Override
	public Integer disableByAppItemId(Long appItemId) {
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("appItemId", appItemId);
		return getSqlSession().update(getStamentNameSpace("disableByAppItemId"), map);
	}

	@Override
	public Integer disableByAppIdAndAppItemId(Long appId, Long appItemId) {
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("appId", appId);
		map.put("appItemId", appItemId);
		return getSqlSession().update(getStamentNameSpace("disableByAppIdAndAppItemId"), map);
	}

	@Override
	public List<Long> findIdsByAppIdAndAppItemId(Long appId, Long appItemId) {
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("appId", appId);
		map.put("appItemId", appItemId);
		return getSqlSession().selectList(getStamentNameSpace("findIdsByAppIdAndAppItemId"), map);
	}

}
