package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;

import cn.com.duiba.goods.center.api.remoteservice.constant.DevCustomizedConstants;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.AppItemDao;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;

/**
 * AppItemDaoImpl
 */
@Repository("appItemDao")
public class AppItemDaoImpl extends BaseCreditsDao implements AppItemDao {

    private String appIdKey = "appId";
    private String statusKey = "status";

    @Override
    public AppItemEntity find(Long id) {
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put("id", id);
        return getSqlSession().selectOne(getStamentNameSpace("find"), queryMap);
    }

    @Override
    public List<AppItemEntity> findByIds(List<Long> ids) {
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put("ids", ids);
        return getSqlSession().selectList(getStamentNameSpace("findByIds"), queryMap);
    }

    @Override
    public void insert(AppItemEntity appItemEntity) {
        getSqlSession().insert(getStamentNameSpace("insert"), appItemEntity);
    }

    @Override
    public Integer update(AppItemEntity appItemEntity) {
        return getSqlSession().update(getStamentNameSpace("update"), appItemEntity);
    }

    @Override
    public Integer delete(Long appId, Long id) {
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put(appIdKey, appId);
        queryMap.put("id", id);
        return getSqlSession().update(getStamentNameSpace("delete"), queryMap);
    }

    @Override
    public Integer deleteByIds(Long appId, List<Long> ids) {
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put(appIdKey, appId);
        queryMap.put("ids", ids);
        return getSqlSession().update(getStamentNameSpace("deleteByIds"), queryMap);
    }

    @Override
    public Integer updateStatus(Long appId, Long id, String status) {
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put(appIdKey, appId);
        queryMap.put("id", id);
        queryMap.put(statusKey, status);
        return getSqlSession().update(getStamentNameSpace("updateStatus"), queryMap);
    }

    @Override
    public Integer updateStatusByIds(Long appId, List<Long> ids, String status) {
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put(appIdKey, appId);
        queryMap.put("ids", ids);
        queryMap.put(statusKey, status);
        return getSqlSession().update(getStamentNameSpace("updateStatusByIds"), queryMap);
    }

    @Override
    public Integer decrStock(Long id) {
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put("id", id);
        return getSqlSession().update(getStamentNameSpace("decrStock"), queryMap);
    }

    @Override
    public Integer incrStock(Long id) {
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put("id", id);
        return getSqlSession().update(getStamentNameSpace("incrStock"), queryMap);
    }

    @Override
    public Integer appendStock(Long id, Long number) {
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put("id", id);
        queryMap.put("number", number);
        return getSqlSession().update(getStamentNameSpace("appendStock"), queryMap);
    }

    @Override
    public Integer deductStock(Long id, Long number) {
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put("id", id);
        queryMap.put("number", number);
        return getSqlSession().update(getStamentNameSpace("deductStock"), queryMap);
    }

    @Override
    public AppItemEntity findByAppIdAndItemId(Long appId, Long itemId) {
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put(appIdKey, appId);
        queryMap.put("itemId", itemId);
        return getSqlSession().selectOne(getStamentNameSpace("findByAppIdAndItemId"), queryMap);
    }
    
    @Override
    public Integer findCountByItemId(Long itemId){
    	 Map<String, Object> queryMap = getBlankParams();
    	 queryMap.put("itemId", itemId);
    	 return getSqlSession().selectOne(getStamentNameSpace("findCountByItemId"), queryMap);
    }

    @Override
    public List<AppItemEntity> findByAppIdAndItemIds(Long appId, List<Long> itemIds) {
        if (CollectionUtils.isEmpty(itemIds)) {
            return new ArrayList<>();
        }
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put(appIdKey, appId);
        queryMap.put("itemIds", itemIds);
        return getSqlSession().selectList(getStamentNameSpace("findByAppIdAndItemIds"), queryMap);
    }

    @Override
    public Integer updateRemainingAndvalidEndDate(Long appItemId, Long totalStock, Date validEndDate) {
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put("id", appItemId);
        queryMap.put("totalStock", totalStock);
        queryMap.put("validEndDate", validEndDate);
        return getSqlSession().update(getStamentNameSpace("updateRemainingAndvalidEndDate"), queryMap);
    }

    @Override
    public Integer updateExpiedAppItem(Long itemId) {
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put("itemId", itemId);
        return getSqlSession().update(getStamentNameSpace("updateExpiedAppItem"), queryMap);
    }

    @Override
    public Integer updateExpiedAppItemById(Long appItemId) {
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put("appItemId", appItemId);
        return getSqlSession().update(getStamentNameSpace("updateExpiedAppItemById"), queryMap);
    }

    @Override
    public List<AppItemDto> findhomeAppItemNeed(Long appId) {
        return getSqlSession().selectList(this.getStamentNameSpace("findhomeAppItemNeed"), appId);
    }

    @Override
    public List<Long> findAppIdsByInActivityId(Long activityId, Integer type) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("activityId", activityId);
        paramMap.put("type", type);
        return getSqlSession().selectList(this.getStamentNameSpace("findAppIdsByInActivityId"), paramMap);
    }

    @Override
    public List<Long> findAppIdsByActivityId(Long relationId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("relationId", relationId);
        return getSqlSession().selectList(this.getStamentNameSpace("findAppIdsByActivityId"), paramMap);
    }

    @Override
    public List<Long> findIdsByActivityIds(List<Long> relationIds) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("relationIds", relationIds);
        return getSqlSession().selectList(this.getStamentNameSpace("findIdsByActivityIds"), paramMap);
    }

    @Override
    public List<Long> findAppIdByItemIds(List<Long> itemIds) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("itemIds", itemIds);
        return getSqlSession().selectList(this.getStamentNameSpace("findAppIdByItemIds"), paramMap);
    }

    @Override
    public List<AppItemDto> findAppItemsByAppIdAndIds(Long appId, String status, List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("appId", appId);
        paramMap.put(statusKey, status);
        paramMap.put("ids", ids);
        return getSqlSession().selectList(this.getStamentNameSpace("findAppItemsByAppIdAndIds"), paramMap);
    }

    @Override
    public List<Long> findAppIdsByIds(List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("ids", ids);
        return getSqlSession().selectList(this.getStamentNameSpace("findAppIdsByIds"), paramMap);
    }

    @Override
    public List<Long> findIdByItemId(Long itemId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("itemId", itemId);
        return getSqlSession().selectList(this.getStamentNameSpace("findIdByItemId"), paramMap);
    }

    @Override
    public List<Long> findIDBySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes, Long appId) {
        if (sourceIds.isEmpty() || sourceTypes.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("sourceIds", sourceIds);
        paramMap.put("sourceTypes", sourceTypes);
        paramMap.put("appId", appId);
        return getSqlSession().selectList(this.getStamentNameSpace("findIDBySourceIdsAndSourceTypes"), paramMap);
    }

    @Override
    public List<AppItemEntity> findBySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes, Long appId) {
        if (sourceIds.isEmpty() || sourceTypes.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("sourceIds", sourceIds);
        paramMap.put("sourceTypes", sourceTypes);
        paramMap.put("appId", appId);
        return getSqlSession().selectList(this.getStamentNameSpace("findBySourceIdsAndSourceTypes"), paramMap);
    }

    @Override
    public int updateStatusByActivityIds(String status, Boolean delete, List<Long> oids) {
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put("status", status);
        queryMap.put("delete", delete);
        queryMap.put("oids", oids);
        return getSqlSession().update(this.getStamentNameSpace("updateStatusByActivityIds"), queryMap);
    }

    @Override
    public List<AppItemDto> findByLimit(Map<String, Object> params) {
        return getSqlSession().selectList(this.getStamentNameSpace("findByLimit"), params);
    }
    
    @Override
    public Integer findByLimitCount(Map<String, Object> params) {
        return getSqlSession().selectOne(getStamentNameSpace("findByLimitCount"), params);
    }

    @Override
    public int findAppMaxPayload(Long appId) {
        Map<String, Object> param = getBlankParams();
        param.put("appId", appId);
        param.put("topStart", AppItemDto.ITEM_TOP_START);
        int payload = getSqlSession().selectOne(this.getStamentNameSpace("findAppMaxPayload"), param);
        //常规兑换项权重值溢出
        if (payload + 1 >= AppItemDto.ITEM_TOP_START) {
            throw new RuntimeGoodsException(ErrorCode.E9999999);
        }
        return payload;
    }

    @Override
    public Integer updateStatusByActivityId(String status, Boolean delete, Long activityId, Integer type) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("status", status);
        paramMap.put("delete", delete);
        paramMap.put("activityId", activityId);
        paramMap.put("type", type);
        return getSqlSession().update(getStamentNameSpace("updateStatusByActivityId"), paramMap);
    }

    @Override
    public List<Long> findIdsByInActivityId(Long activityId, Integer type) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("activityId", activityId);
        paramMap.put("type", type);
        return getSqlSession().selectList(getStamentNameSpace("findIdsByInActivityId"), paramMap);
    }

    @Override
    public List<Long> findTopAppItemIdsDescByPayload(Long appId) {
        Map<String, Object> param = new HashMap<>();
        param.put("appId", appId);
        param.put("topStart", DevCustomizedConstants.ITEM_TOP_START);
        return getSqlSession().selectList(getStamentNameSpace("findTopAppItemIdsDescByPayload"), param);
    }

    @Override
    public int updateAppItemPayload(Long appId, Long appItemId, Integer payload) {
        AppItemEntity entity = new AppItemEntity();
        entity.setId(appItemId);
        entity.setAppId(appId);
        entity.setPayload(payload);
        return getSqlSession().update(getStamentNameSpace("updateAppItemPayload"), entity);
    }

    @Override
    public int updateOfflineAppItem4Disable(Long appId) {
        Map<String,Object> param = Maps.newHashMap();
        param.put("appId",appId);
        return getSqlSession().update(getStamentNameSpace("updateOfflineAppItem4Disable"), param);
    }

    @Override
    public List<Long> findOfflineAppItemIds4Disable(Long appId) {
        Map<String,Object> param = Maps.newHashMap();
        param.put("appId",appId);
        return getSqlSession().selectList(getStamentNameSpace("findOfflineAppItemIds4Disable"), param);
    }

	@Override
	public List<AppItemDto> findOnShelfByItemId(Long itemId) {
		Map<String, Object> param = Maps.newHashMap();
		param.put("itemId", itemId);
		return getSqlSession().selectList(getStamentNameSpace("findOnShelfByItemId"), param);
	}

    @Override
    public int standUpOrDownAppItem(Long id, String status, Boolean deleted, Integer payload, Boolean homeDisplay) {
        Map<String, Object> paramMap = getBlankParams();
        paramMap.put("id", id);
        paramMap.put("status", status);
        paramMap.put("deleted", deleted);
        paramMap.put("payload", payload);
        paramMap.put("homeDisplay", homeDisplay);
        return getSqlSession().update(getStamentNameSpace("standUpOrDownAppItem"), paramMap);
    }

	@Override
	public int updateHdtoolAppItem(Long id, String title, String smallImage, String whiteImage, Long credits, String customPrice, String logo, Integer operationsType) {
		Map<String, Object> paramMap = getBlankParams();
		paramMap.put("id", id);
		paramMap.put("title", title);
		paramMap.put("smallImage", smallImage);
		paramMap.put("whiteImage", whiteImage);
		paramMap.put("credits", credits);
		paramMap.put("customPrice", customPrice);
		paramMap.put("logo", logo);
		paramMap.put("operationsType", operationsType);
		return getSqlSession().update(getStamentNameSpace("updateHdtoolAppItem"), paramMap);
	}
	
	@Override
	public int updateMainPushAppItem(Long id, String title, String logo, String smallImage, String whiteImage, String bannerImage, Long credits, String subtitle) {
		Map<String, Object> paramMap = getBlankParams();
		paramMap.put("id", id);
		paramMap.put("title", title);
		paramMap.put("logo", logo);
		paramMap.put("smallImage", smallImage);
		paramMap.put("whiteImage", whiteImage);
		paramMap.put("bannerImage", bannerImage);
		paramMap.put("credits", credits);
		paramMap.put("subtitle", subtitle);
		return getSqlSession().update(getStamentNameSpace("updateMainPushAppItem"), paramMap);
	}

	@Override
	public List<AppItemDto> findAllBySourceTypeAndRelationIdAndDeleted(Integer sourceType, Long sourceRelationId, Boolean deleted) {
		Map<String, Object> paramMap = getBlankParams();
		paramMap.put("sourceType", sourceType);
		paramMap.put("sourceRelationId", sourceRelationId);
		paramMap.put("deleted", deleted);
		return getSqlSession().selectList(getStamentNameSpace("findAllBySourceTypeAndRelationIdAndDeleted"), paramMap);
	}

	@Override
	public List<AppItemDto> findPublishItemLimit(Map<String, Object> queryPublish) {
		return getSqlSession().selectList(getStamentNameSpace("findPublishItemLimit"), queryPublish);
	}

	@Override
	public Integer countPublishItemRow(Map<String, Object> queryPublish) {
		return getSqlSession().selectOne(getStamentNameSpace("countPublishItemRow"), queryPublish);
	}

	@Override
	public Integer updateSubTypeById(Long id, Integer subType) {
		Map<String, Object> paramMap = getBlankParams();
		paramMap.put("id", id);
		paramMap.put("subType", subType);
		return getSqlSession().update(getStamentNameSpace("updateSubTypeById"), paramMap);
	}

	@Override
	public int updateValidEndDateById(Long appItemId, Date validEndDate) {
		Map<String, Object> paramMap = getBlankParams();
		paramMap.put("id", appItemId);
		paramMap.put("validEndDate", validEndDate);
		return getSqlSession().update(getStamentNameSpace("updateValidEndDateById"), paramMap);
	}

	@Override
	public List<AppItemDto> findAllByAppIdAndInType(Long appId, String[] type) {
		Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("appId", appId);
        paramMap.put("type", type);
        return getSqlSession().selectList(getStamentNameSpace("findAllByAppIdAndInType"), paramMap);
	}
	
    @Override
    public Integer findOnlineCount(Long appId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("appId", appId);
        return getSqlSession().selectOne(getStamentNameSpace("findOnlineCount"), paramMap);
    }
    
    @Override
    public List<AppItemDto> findOnlineAppItems(Long appId) {
    	Map<String, Object> paramMap = new HashMap<>();
    	paramMap.put("appId", appId);
    	return getSqlSession().selectList(getStamentNameSpace("findOnlineAppItems"), paramMap);
    }

	@Override
	public List<AppItemDto> findAllUpVirtaulAppItems(Long appId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("appId", appId);
        return getSqlSession().selectList(getStamentNameSpace("findAllUpVirtaulAppItems"), paramMap);
	}

	@Override
	public void updateOperationsTypeById(Long id, Integer operationsType) {
		Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("operationsType", operationsType);
        getSqlSession().update(getStamentNameSpace("updateOperationsTypeById"), paramMap);
	}

	@Override
	public void setLimitNull(Long appItemId, Integer limitCount, String limitTimeBetween, Integer limitEverydayQuantity) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("appItemId", appItemId);
		paramMap.put("limitCount", limitCount);
		paramMap.put("limitTimeBetween", limitTimeBetween);
		paramMap.put("limitEverydayQuantity", limitEverydayQuantity);
		getSqlSession().update(getStamentNameSpace("setLimitNull"), paramMap);
	}

	@Override
	public Integer deleteOrRecoverAppItem(Long appId, Long id, Boolean deleted, String status) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("appId", appId);
        paramMap.put("deleted", deleted);
        paramMap.put("status", status);
        return getSqlSession().update(getStamentNameSpace("deleteOrRecoverAppItem"), paramMap);
	}
	
	@Override
    public List<Long> findSelfAppItemIdsByAppId(Long appId,List<String> types,Integer warnLine){
	    Map<String, Object> paramMap = getBlankParams();
	    paramMap.put("appId", appId);
	    paramMap.put("types", types);
	    paramMap.put("warnLine", warnLine);
	    return getSqlSession().selectList(getStamentNameSpace("findSelfAppItemIdsByAppId"), paramMap);
	}
}
