package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.CouponBatchDao;
import cn.com.duiba.goods.center.biz.entity.CouponBatchEntity;

/**
 * 优惠券批次实现类
 */
@Repository
public class CouponBatchDaoImpl extends BaseCreditsDao implements CouponBatchDao {

	private String itemIdKey = "itemId";
	private String appItemIdKey = "appItemId";
	private String batchIdKey = "batchId";
	private String validStartDateKey = "validStartDate";
	private String validEndDateKey = "validEndDate";

	@Override
	public void insert(CouponBatchEntity couponBatchEntity) {
		getSqlSession().insert(getStamentNameSpace("insert"), couponBatchEntity);
	}

	@Override
	public int update(CouponBatchEntity couponBatchEntity) {
		return getSqlSession().update(getStamentNameSpace("update"), couponBatchEntity);
	}

	@Override
	public CouponBatchEntity findForUpdate(Long id) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("id", id);
		return getSqlSession().selectOne(getStamentNameSpace("findForUpdate"), paramMap);
	}

	@Override
	public CouponBatchEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("id", id);
		return getSqlSession().selectOne(getStamentNameSpace("find"), paramMap);
	}

	@Override
	public CouponBatchEntity findLastBatchByItemId(Long itemId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(itemIdKey, itemId);
		return getSqlSession().selectOne(getStamentNameSpace("findLastBatchByItemId"), paramMap);
	}

	@Override
	public List<CouponBatchEntity> findAllBatch(Long appItemId, Long itemId, String valid) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(appItemIdKey, appItemId);
		paramMap.put(itemIdKey, itemId);
		paramMap.put("valid", valid);
		return getSqlSession().selectList(getStamentNameSpace("findAllBatch"), paramMap);
	}

	@Override
	public void updateAllNewOverDueBatch() {
		getSqlSession().update(getStamentNameSpace("updateAllNewOverDueBatch"));
	}

	@Override
	public List<Long> selectIdsOfNewOverDueBatch() {
		return getSqlSession().selectList(getStamentNameSpace("selectIdsOfNewOverDueBatch"));
	}

	@Override
	public void setItemBatchEmpty(Long itemId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(itemIdKey, itemId);
		getSqlSession().update(getStamentNameSpace("setItemBatchEmpty"), paramMap);
	}

	@Override
	public void setAppItemBatchEmpty(Long appItemId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(appItemIdKey, appItemId);
		getSqlSession().update(getStamentNameSpace("setAppItemBatchEmpty"), paramMap);
	}

	@Override
	public CouponBatchEntity findBatchByValidEndDate(Long appItemId, Long itemId, Date validEndDate) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(appItemIdKey, appItemId);
		paramMap.put(itemIdKey, itemId);
		paramMap.put(validEndDateKey, validEndDate);
		return getSqlSession().selectOne(getStamentNameSpace("findBatchByValidEndDate"), paramMap);
	}

	@Override
	public CouponBatchEntity findBatchByValidStartDateAndValidEndDate(Long appItemId, Long itemId, Date validStartDate, Date validEndDate) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(appItemIdKey, appItemId);
		paramMap.put(itemIdKey, itemId);
		paramMap.put(validStartDateKey, validStartDate);
		paramMap.put(validEndDateKey, validEndDate);
		return getSqlSession().selectOne(getStamentNameSpace("findBatchByValidStartDateAndValidEndDate"), paramMap);
	}

	@Override
	public Date getMaxValidEndDate(Long appItemId, Long itemId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(appItemIdKey, appItemId);
		paramMap.put(itemIdKey, itemId);
		return getSqlSession().selectOne(getStamentNameSpace("getMaxValidEndDate"), paramMap);
	}

	@Override
	public Date getMinValidEndDate(Long appItemId, Long itemId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(appItemIdKey, appItemId);
		paramMap.put(itemIdKey, itemId);
		return getSqlSession().selectOne(getStamentNameSpace("getMinValidEndDate"), paramMap);
	}

	@Override
	public Integer countAllRemaining(Long appItemId, Long itemId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(appItemIdKey, appItemId);
		paramMap.put(itemIdKey, itemId);
		Integer sum = getSqlSession().selectOne(getStamentNameSpace("countAllRemaining"), paramMap);
		return sum == null ? 0 : sum;
	}

	@Override
	public Integer deleteBatchRecord(Long batchId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		return getSqlSession().delete(getStamentNameSpace("deleteBatchRecord"), paramMap);
	}

	@Override
	public Integer turnbackCouponBatchRemaining(Long batchId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		return getSqlSession().update(getStamentNameSpace("turnbackCouponBatchRemaining"), paramMap);
	}

	@Override
	public Integer reduceCouponBatchRemaining(Long batchId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		return getSqlSession().update(getStamentNameSpace("reduceCouponBatchRemaining"), paramMap);
	}

	@Override
	public Integer countBatchRemaining(Long batchId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		return getSqlSession().selectOne(getStamentNameSpace("countBatchRemaining"), paramMap);
	}

	@Override
	public List<CouponBatchEntity> findBatchInIds(List<Long> ids) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("ids", ids);
		return getSqlSession().selectList(getStamentNameSpace("findBatchInIds"), paramMap);
	}

	@Override
	public CouponBatchEntity findItemNextBatch(Long itemId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(itemIdKey, itemId);
		return getSqlSession().selectOne(getStamentNameSpace("findItemNextBatch"), paramMap);
	}

	@Override
	public CouponBatchEntity findAppItemNextBatch(Long appItemId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(appItemIdKey, appItemId);
		return getSqlSession().selectOne(getStamentNameSpace("findAppItemNextBatch"), paramMap);
	}

	@Override
	public CouponBatchEntity findItemMaxValidEndDateBatch(Long itemId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(itemIdKey, itemId);
		return getSqlSession().selectOne(getStamentNameSpace("findItemMaxValidEndDateBatch"), paramMap);
	}

	@Override
	public CouponBatchEntity findAppItemMaxValidEndDateBatch(Long appItemId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(appItemIdKey, appItemId);
		return getSqlSession().selectOne(getStamentNameSpace("findAppItemMaxValidEndDateBatch"), paramMap);
	}

	@Override
	public int updateActiveAndRemaining(Long id, Integer active, Integer remaining) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("id", id);
		paramMap.put("active", active);
		paramMap.put("remaining", remaining);
		return getSqlSession().update(getStamentNameSpace("updateActiveAndRemaining"), paramMap);
	}

	@Override
	public int updateActive(Long id, Integer active) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("id", id);
		paramMap.put("active", active);
		return getSqlSession().update(getStamentNameSpace("updateActive"), paramMap);
	}

	@Override
	public CouponBatchEntity findItemBatchByValidStartDateAndValidEndDate(Long itemId, Date validStartDate, Date validEndDate) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(itemIdKey, itemId);
		paramMap.put(validStartDateKey, validStartDate);
		paramMap.put(validEndDateKey, validEndDate);
		return getSqlSession().selectOne(getStamentNameSpace("findItemBatchByValidStartDateAndValidEndDate"), paramMap);
	}

	@Override
	public CouponBatchEntity findAppItemBatchByValidStartDateAndValidEndDate(Long appItemId, Date validStartDate, Date validEndDate) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(appItemIdKey, appItemId);
		paramMap.put(validStartDateKey, validStartDate);
		paramMap.put(validEndDateKey, validEndDate);
		return getSqlSession().selectOne(getStamentNameSpace("findAppItemBatchByValidStartDateAndValidEndDate"), paramMap);
	}

	@Override
	public List<CouponBatchEntity> findAllBatchSimple(Long appItemId) {
		return getSqlSession().selectList(getStamentNameSpace("findAllBatchSimple"), appItemId);
	}

	@Override
	public Long findBatchNum(Long appItemId) {
		return getSqlSession().selectOne(getStamentNameSpace("findBatchNum"), appItemId);
	}

	@Override
	public Integer asyncUpdateBatchStock(Long batchId, int decrease) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		paramMap.put("decrease", decrease);
		return getSqlSession().update(getStamentNameSpace("asyncUpdateBatchStock"), paramMap);
	}
	
	@Override
	public int setItemBatchId(Long itemId, Long batchId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		paramMap.put(itemIdKey, itemId);
		return getSqlSession().update(getStamentNameSpace("setItemBatchId"), paramMap);
	}
	
	@Override
	public int setAppItemBatchId(Long appItemId, Long batchId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		paramMap.put(appItemIdKey, appItemId);
		return getSqlSession().update(getStamentNameSpace("setAppItemBatchId"), paramMap);
	}
	
}
