package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.CouponDao;
import cn.com.duiba.goods.center.biz.entity.CouponEntity;

/**
 * 优惠券DAO实现类
 */
@Repository
public class CouponDaoImpl extends BaseCreditsDao implements CouponDao {

	private String itemIdKey = "itemId";
	private String appItemIdKey = "appItemId";
	private String batchIdKey = "batchId";

	@Override
	public CouponEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("id", id);
		return getSqlSession().selectOne(getStamentNameSpace("find"), paramMap);
	}

	@Override
	public void releaseCouponById(Long couponId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("couponId", couponId);
		getSqlSession().update(getStamentNameSpace("releaseCouponById"), paramMap);
	}

	@Override
	public int batchInsertCoupon(List<CouponEntity> ls) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("list", ls);
		return getSqlSession().insert(getStamentNameSpace("batchInsertCoupon"), paramMap);
	}

	@Override
	public Integer batchDeleteCoupon(List<Long> ls) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("list", ls);
		return getSqlSession().delete(getStamentNameSpace("batchDeleteCoupon"), paramMap);
	}

	@Override
	public Integer deleteOneCoupon(Long id) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("id", id);
		return getSqlSession().delete(getStamentNameSpace("deleteOneCoupon"), paramMap);
	}

	@Override
	public Integer deleteCouponByBatch(Long batchId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		return getSqlSession().delete(getStamentNameSpace("deleteCouponByBatch"), paramMap);
	}

	@Override
	public Integer ishavingCoupon(Long batchId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		return getSqlSession().selectOne(getStamentNameSpace("ishavingCoupon"), paramMap);
	}

	@Override
	public CouponEntity getOneCouponByBatchForUpdate(Long batchId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		return getSqlSession().selectOne(getStamentNameSpace("getOneCouponByBatchForUpdate"), paramMap);
	}

	@Override
	public CouponEntity findOneByBatch(Long batchId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		return getSqlSession().selectOne(getStamentNameSpace("findOneByBatch"), paramMap);
	}

	@Override
	public CouponEntity findByBatchAndCode(Long batchId, String code) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		paramMap.put("code", code);
		return getSqlSession().selectOne(getStamentNameSpace("findByBatchAndCode"), paramMap);
	}

	@Override
	public List<CouponEntity> findNoUsedByBatch(Long batchId, Integer max) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		paramMap.put("max", max);
		return getSqlSession().selectList(getStamentNameSpace("findNoUsedByBatch"), paramMap);
	}

	@Override
	public List<CouponEntity> searchCoupon(Long appItemId, Long itemId, String code, Long batchId, String used, Integer start, Integer pageSize) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(appItemIdKey, appItemId);
		paramMap.put(itemIdKey, itemId);
		paramMap.put("code", code);
		paramMap.put(batchIdKey, batchId);
		paramMap.put("used", used);
		paramMap.put("start", start);
		paramMap.put("pageSize", pageSize);
		return getSqlSession().selectList(getStamentNameSpace("searchCoupon"), paramMap);
	}

	@Override
	public Integer countCoupon(Long appItemId, Long itemId, Long batchId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(appItemIdKey, appItemId);
		paramMap.put(itemIdKey, itemId);
		paramMap.put(batchIdKey, batchId);
		return getSqlSession().selectOne(getStamentNameSpace("countCoupon"), paramMap);
	}

	@Override
	public Integer countUsedCoupon(Long appItemId, Long itemId, Long batchId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(appItemIdKey, appItemId);
		paramMap.put(itemIdKey, itemId);
		paramMap.put(batchIdKey, batchId);
		return getSqlSession().selectOne(getStamentNameSpace("countUsedCoupon"), paramMap);
	}

	@Override
	public Integer countByItemId(Long itemId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(itemIdKey, itemId);
		return getSqlSession().selectOne(getStamentNameSpace("countByItemId"), paramMap);
	}

	@Override
	public List<CouponEntity> findCouponList(List<Long> list) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("list", list);
		return getSqlSession().selectList(getStamentNameSpace("findCouponList"), paramMap);
	}

	@Override
	public Integer countByCouponBatch(Long batchId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		return getSqlSession().selectOne(getStamentNameSpace("countByCouponBatch"), paramMap);
	}

	@Override
	public List<CouponEntity> findCouponByLimit(Map<String, Object> params) {
		return getSqlSession().selectList(getStamentNameSpace("findCouponByLimit"), params);
	}

	@Override
	public Long findCouponByCount(Map<String, Object> params) {
		return getSqlSession().selectOne(getStamentNameSpace("findCouponByCount"), params);
	}

	@Override
	public List<CouponEntity> findCouponByBatchAndTotal(Map<String, Object> map) {
		return getSqlSession().selectList(getStamentNameSpace("findCouponByBatchAndTotal"), map);
	}

	@Override
	public int lockCoupon(long id) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("id", id);
		return getSqlSession().update(getStamentNameSpace("lockCoupon"), paramMap);
	}

	@Override
	public int unlockCoupon(long id) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("id", id);
		return getSqlSession().update(getStamentNameSpace("unlockCoupon"), paramMap);
	}

	@Override
	public int deleteByBatchId(long batchId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		return getSqlSession().delete(getStamentNameSpace("deleteByBatchId"), paramMap);
	}

	@Override
	public List<String> findAllCodeByBatchId(long batchId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		return getSqlSession().selectList(getStamentNameSpace("findAllCodeByBatchId"), paramMap);
	}

	@Override
	public Integer noLockCountByBatchId(Long batchId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		return getSqlSession().selectOne(getStamentNameSpace("noLockCountByBatchId"), paramMap);
	}

	@Override
	public CouponEntity findOneCouponByBatchId(Long batchId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put(batchIdKey, batchId);
		return getSqlSession().selectOne(getStamentNameSpace("findOneCouponByBatchId"), paramMap);
	}

	@Override
	public List<CouponEntity> findCouponsForUpdate(long batchId, int limit) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("limit", limit);
		paramMap.put(batchIdKey, batchId);
		return getSqlSession().selectList(getStamentNameSpace("findCouponsForUpdate"), paramMap);
	}

	@Override
	public Integer asyncLockedCoupon(List<Long> ids) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("ids", ids);
		return getSqlSession().selectOne(getStamentNameSpace("asyncLockedCoupon"), paramMap);
	}

	@Override
	public int useCoupon(Long couponId, Long orderId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("couponId", couponId);
		paramMap.put("orderId", orderId);
		return getSqlSession().update(getStamentNameSpace("useCoupon"), paramMap);
	}

	@Override
	public void insert(CouponEntity couponEntity) {
		getSqlSession().insert(getStamentNameSpace("insert"), couponEntity);
	}
}
