package cn.com.duiba.goods.center.biz.entity;

import java.io.Serializable;
import java.util.Date;

/**
 * 库存手动变更明细
 */
public class ItemStockManualChangeEntity implements Serializable {

	private static final long serialVersionUID = 7370646128875067325L;

	public static final String TYPE_DUIBA_ITEM = "item";
	public static final String TYPE_DEV_ITEM = "appItem";
	public static final String KIND_ADD = "add";
	public static final String KIND_SUB = "sub";

	private Long id;
	private Long relationId;
	private String relationType;
	private String changeKind;
	private Long changeQuantity;
	private Long beforeStock;
	private Long afterStock;
	private Date gmtCreate;
	private Date gmtModified;

	/**
	 * init4insert
	 * @param init4insert
	 */
	public ItemStockManualChangeEntity(boolean init4insert) {
		if (init4insert) {
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}

	/**
	 * default
	 */
	public ItemStockManualChangeEntity() {
	}

	/**
	 * id
	 * @param id
	 */
	public ItemStockManualChangeEntity(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getRelationId() {
		return relationId;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public String getRelationType() {
		return relationType;
	}

	public void setRelationType(String relationType) {
		this.relationType = relationType;
	}

	public String getChangeKind() {
		return changeKind;
	}

	public void setChangeKind(String changeKind) {
		this.changeKind = changeKind;
	}

	public Long getChangeQuantity() {
		return changeQuantity;
	}

	public void setChangeQuantity(Long changeQuantity) {
		this.changeQuantity = changeQuantity;
	}

	public Long getBeforeStock() {
		return beforeStock;
	}

	public void setBeforeStock(Long beforeStock) {
		this.beforeStock = beforeStock;
	}

	public Long getAfterStock() {
		return afterStock;
	}

	public void setAfterStock(Long afterStock) {
		this.afterStock = afterStock;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

}
