/**
 * Project Name:goods-center-biz
 * File Name:RemotePCGConsumerServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.remoteservice.pcg
 * Date:2016年6月30日下午5:45:13
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.remoteservice.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.front.RemoteGoodsConsumerService;
import cn.com.duiba.goods.center.biz.entity.GoodsLimitRecordEntity;
import cn.com.duiba.goods.center.biz.remoteservice.pcg.RemoteGoodsBatchServiceImpl;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemotePCGConsumerServiceImpl <br/>
 * Date:     2016年6月30日 下午5:45:13 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("remoteGoodsConsumerService")
public class RemoteGoodsConsumerServiceImpl implements RemoteGoodsConsumerService {
	private static Logger log=LoggerFactory.getLogger(RemoteGoodsBatchServiceImpl.class);
    @Autowired
    private GoodsLimitRecordService goodsLimitRecordService;
    @Override
    public DubboResult<Integer> findConsumerExchangeCount2(int gtype, long gid, long consumerId) {
    	try{
    		 int count=goodsLimitRecordService.findCount(gtype, gid, consumerId);
    		 return DubboResult.successResult(count);
    	}catch(Exception e){
			log.error("findConsumerExchangeCount gtype=" + gtype + ",gid=" + gid+ ",consumerId=" + consumerId, e);
			return DubboResult.failResult(e.getMessage());
		}
    }
	@Override
	public DubboResult<Map<Long, Integer>> findConsumerExchangeCounts(int gtype,
			List<Long> gids, long consumerId) {
		try{
		    if(gids.isEmpty()){
		        Map<Long, Integer> map=new HashMap<>();
	            return DubboResult.successResult(map);
	        }
		    
			List<GoodsLimitRecordEntity> list = goodsLimitRecordService.findCounts(gtype, gids, consumerId);
			Map<Long, Integer>  map = new HashMap<>();
			for(GoodsLimitRecordEntity glre: list){
				map.put(glre.getGid(), glre.getCount());
			}
			 return DubboResult.successResult(map);
		}catch(Exception e){
			log.error("findConsumerExchangeCounts gtype=" + gtype + ",consumerId=" + consumerId, e);
			return DubboResult.failResult(e.getMessage());
		}
	}
	@Override
	public Integer findConsumerExchangeCount(int gtype, long gid,
			long consumerId) {
		return goodsLimitRecordService.findCount(gtype, gid, consumerId);
	}

}

