package cn.com.duiba.goods.center.biz.remoteservice.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.RemoteAppItemGoodsService;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.HomeAppItemService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by liuyao on 2016/11/16.
 */
@Service("remoteAppItemGoodsService")
public class RemoteAppItemGoodsServiceImpl implements RemoteAppItemGoodsService {
    @Autowired
    private AppItemService appItemService;
    @Autowired
    private HomeAppItemService homeAppItemService;

	@Override
	public DubboResult<AppItemDto> find(Long id) {
		AppItemEntity entity = appItemService.find(id);
		if (entity != null && entity.getDeleted()) {
			return DubboResult.successResult(null);
		}
		AppItemDto ret = BeanUtils.copy(entity, AppItemDto.class);
		return DubboResult.successResult(ret);
	}

    @Override
    public DubboResult<List<AppItemDto>> findBannerIconAppItemByCache(Long appId,List<Long> appItems) {
        return DubboResult.successResult(homeAppItemService.findBannerIconAppItemByCache(appId,appItems));
    }
}
