package cn.com.duiba.goods.center.biz.remoteservice.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.RemoteGoodsAppItemExtraService;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemExtraDto;
import cn.com.duiba.goods.center.biz.entity.AppItemExtraEntity;
import cn.com.duiba.goods.center.biz.service.item.AppItemExtraService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by xiaoxuda on 2016/12/6.
 */
@Service("remoteGoodsAppItemExtraService")
public class RemoteGoodsAppItemExtraServiceImpl implements RemoteGoodsAppItemExtraService {
    @Autowired
    private AppItemExtraService appItemExtraService;

    @Override
    public DubboResult<AppItemExtraDto> findByAppItemId(Long appItemId) {
        AppItemExtraEntity entity = appItemExtraService.findByAppItemId(appItemId);
        AppItemExtraDto result = entity == null ? null : BeanUtils.copy(entity, AppItemExtraDto.class);
        return DubboResult.successResult(result);
    }

    @Override
    public DubboResult<Integer> insert(AppItemExtraDto appItemExtra) {
        return DubboResult.successResult(appItemExtraService.insert(BeanUtils.copy(appItemExtra, AppItemExtraEntity.class)));
    }

    @Override
    public DubboResult<Integer> updateByAppItemId(AppItemExtraDto appItemExtra) {
        return DubboResult.successResult(appItemExtraService.updateByAppItemId(BeanUtils.copy(appItemExtra, AppItemExtraEntity.class)));
    }

    @Override
    public DubboResult<Integer> deleteByAppItemId(Long appItemId) {
        return DubboResult.successResult(appItemExtraService.deleteByAppItemId(appItemId));
    }

    @Override
    public DubboResult<Integer> insertOrUpdateByAppItemId(AppItemExtraDto appItemExtra) {
        return DubboResult.successResult(appItemExtraService.insertOrUpdateByAppItemId(BeanUtils.copy(appItemExtra, AppItemExtraEntity.class)));
    }


}
