package cn.com.duiba.goods.center.biz.remoteservice.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteGoodsItemLimitService;
import cn.com.duiba.goods.center.biz.service.item.EverydayLimitService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @deprecated
 * RemoteGoodsItemLimitServiceImpl
 *
 */
@Service("remoteGoodsItemLimitService")
public class RemoteGoodsItemLimitServiceImpl implements RemoteGoodsItemLimitService {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteGoodsItemLimitServiceImpl.class);

    @Autowired
    private EverydayLimitService everydayLimitService;

    @Override
    public DubboResult<Boolean> addQuantityLimitCounter(ItemKeyDto itemKey) {
        try {
            Boolean result = everydayLimitService.decrEeverydayStock(itemKey);
            return DubboResult.successResult(result);
        } catch (GoodsException e) {
			if (ErrorCode.E0404011.getErrorCode().equals(e.getResultCode())) {
				LOGGER.warn("addQuantityLimitCounter" + e.getMessage());
				return DubboResult.successResult(false);
			}
            LOGGER.error("addQuantityLimitCounter error, ", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> subQuantityLimitCounter(ItemKeyDto itemKey) {
        try {
            Boolean result = everydayLimitService.incrEverydayStock(itemKey);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("subQuantityLimitCounter error, ", e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
