package cn.com.duiba.goods.center.biz.remoteservice.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.RemoteImmediatelyButtonBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.TbGoodsOpenUrlDto;
import cn.com.duiba.goods.center.biz.service.TbGoodsOpenurlService;
import cn.com.duiba.wolf.dubbo.DubboResult;

@Service
public class RemoteImmediatelyButtonBackendServiceImpl implements RemoteImmediatelyButtonBackendService {

	@Autowired
	private TbGoodsOpenurlService tbGoodsOpenurlService;

	@Override
	public DubboResult<Void> updateTbGoodsOpenurl(Long itemId, String androidDownload, String iosDownload, Integer immediatelyButton, GoodsTypeEnum gtype, Long switches) {
		TbGoodsOpenUrlDto dto = new TbGoodsOpenUrlDto();
		dto.setGid(itemId);
		dto.setAndroidDownload(androidDownload);
		dto.setIosDownload(iosDownload);
		dto.setImmediatelyButton(immediatelyButton);
		dto.setGtype(gtype.getGtype());
		dto.setSwitches(switches);
		tbGoodsOpenurlService.updateTbGoodsOpenurl(dto);
		return DubboResult.successResult(null);
	}

	@Override
	public DubboResult<TbGoodsOpenUrlDto> selectTbGoodsOpenurlByid(Long itemId, GoodsTypeEnum gtype) {
		TbGoodsOpenUrlDto dto = tbGoodsOpenurlService.findTbGoodsOpenurl(itemId, gtype.getGtype());
		return DubboResult.successResult(dto);
	}

}
