package cn.com.duiba.goods.center.biz.remoteservice.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemExtraDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteItemExtraService;
import cn.com.duiba.goods.center.biz.service.item.ItemExtraService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 2017/2/16.
 */
@Service
public class RemoteItemExtraServiceImpl implements RemoteItemExtraService {
    @Resource
    private ItemExtraService itemExtraService;

    @Override
    public DubboResult<ItemExtraDto> findByItemId(Long itemId) {
        return DubboResult.successResult(itemExtraService.findByItemId(itemId));
    }

    @Override
    public DubboResult<List<ItemExtraDto>> findByItemIds(List<Long> itemIds) {
        return DubboResult.successResult(itemExtraService.findByItemIds(itemIds));
    }

    @Override
    public DubboResult<List<ItemExtraDto>> findByName4Admin(String name) {
        return DubboResult.successResult(itemExtraService.findByName4Admin(name));
    }

    @Override
    public DubboResult<Integer> insert(ItemExtraDto itemExtra) {
        return DubboResult.successResult(itemExtraService.insert(itemExtra));
    }

    @Override
    public DubboResult<Integer> update(ItemExtraDto itemExtra) {
        return DubboResult.successResult(itemExtraService.update(itemExtra));
    }
}
