package cn.com.duiba.goods.center.biz.remoteservice.item;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.CreditsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.PreStockDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemotePreStockService;
import cn.com.duiba.goods.center.biz.bo.CreditsCalculateBo;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.item.PreStockService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by liuyao on 2017/1/11.
 */
@Service
public class RemotePreStockServiceImpl implements RemotePreStockService {

	private static final Logger log = LoggerFactory.getLogger(RemotePreStockServiceImpl.class);

	@Autowired
	private PreStockService preStockService;
	@Autowired
	private CreditsCalculateBo creditsCalculateBo;

	@Override
	public DubboResult<List<PreStockDto>> findAllPreStock(List<Long> itemIds, Long appId) {
		return DubboResult.successResult(preStockService.findAllPreStock(itemIds, appId));
	}

	@Override
	public DubboResult<Long> calculateCreditsByItemKeyAndDegree(ItemKeyDto key, String degree, Long appRate) {
		try {
			if (key == null || key.getAppId() == null || appRate == null) {
				throw new RuntimeGoodsException(ErrorCode.E0404004);
			}
			return DubboResult.successResult(creditsCalculateBo.calculateCreditsByItemKeyAndDegree(key, degree, appRate));
		} catch (RuntimeGoodsException e) {
			log.warn("calculateCreditsByItemKeyAndDegree:", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Integer> getMinExchangePrice(ItemDto item, Long appId) {
		ItemEntity itemEntity = BeanUtils.copy(item, ItemEntity.class);
		Integer prePrice = preStockService.getMinExchangePrice(itemEntity, appId);
		return DubboResult.successResult(prePrice);
	}

	@Override
	public DubboResult<Integer> findPreEeverdayStock(ItemDto itemDto, Long appId) {
		ItemEntity itemEntity = BeanUtils.copy(itemDto, ItemEntity.class);
		Integer stock = preStockService.findPreEverydayStock(itemEntity, appId);
		return DubboResult.successResult(stock);
	}

	@Override
	public DubboResult<List<CreditsDto>> calculateCreditsByItemKeyAndDegree(List<CreditsDto> itemKeys) {
		for (CreditsDto dto : itemKeys) {
			dto.setCredis(creditsCalculateBo.calculateCreditsByItemKeyAndDegree(dto.getItemKey(), dto.getDegree(), dto.getAppCreditsRate()));
		}
		return DubboResult.successResult(itemKeys);
	}
}
