package cn.com.duiba.goods.center.biz.service;

import cn.com.duiba.goods.center.common.GoodsException;

import java.util.List;

/**
 * Created by xiaoxuda on 2017/3/27.
 */
public interface DevCustomizedService {

    /**
     * 对传入的appItem序列进行权重倒序排序，
     *
     * @param appId
     * @param sortAppItemIds 需要排序的AppItemId列表
     */
    boolean indexItemSort(Long appId, List<Long> sortAppItemIds) throws GoodsException;

    /**
     * appItem序列置顶
     *
     * @param appId
     * @param appItemId   需要置顶的AppItemId
     * @throws GoodsException
     */
    boolean setTop4IndexItem(Long appId, Long appItemId) throws GoodsException;

    /**
     * appItem取消置顶
     *
     * @param appId
     * @param appItemId   需要取消置顶的AppItemId
     */
    boolean cancelTop4IndexItem(Long appId, Long appItemId) throws GoodsException;
}
