/**
 * Project Name:goods-center-biz
 * File Name:PlatformCouponGoodsService.java
 * Package Name:cn.com.duiba.goods.center.biz.service
 * Date:2016年5月27日下午1:09:34
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service;

import java.util.List;
import java.util.Map;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGEditDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGInsertDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;

/**
 * ClassName:PlatformCouponGoodsService <br/>
 * Date:     2016年5月27日 下午1:09:34 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface PlatformCouponGoodsService {

	/**
	 * createPlatformCouponGoods
	 * @param goods
	 * @return
	 */
    public Long createPlatformCouponGoods(PCGInsertDto goods);
    
    /**
     * find
     * @param pcgId
     * @return
     */
    public PlatformCouponGoodsEntity find(long pcgId);
    
    /**
     * findIncludeDeleted
     * @param pcgId
     * @return
     */
    public PlatformCouponGoodsEntity findIncludeDeleted(long pcgId) ;

    /**
     * findListByIds
     * @param pcgIds
     * @return
     */
    public List<PlatformCouponGoodsEntity> findListByIds(List<Long> pcgIds);

    /**
     * findByIds
     * @param pcgIds
     * @return
     */
    public Map<Long, PlatformCouponGoodsEntity> findByIds(List<Long> pcgIds);

    /**
     * editPlatformCouponGoods
     * @param pcgId
     * @param goods
     */
    public void editPlatformCouponGoods(Long pcgId, PCGEditDto goods);
    /**
     * 更新商品的券类型
     *
     * @author xuhengfei
     * @param pcgId
     * @param couponType
     * @since JDK 1.6
     */
    public boolean editPlatformCouponType(Long pcgId,int couponType);

    /**
     * onshelfGoods
     * @param pcgId
     */
    public void onshelfGoods(Long pcgId);

    /**
     * offshelfGoods
     * @param pcgId
     */
    public void offshelfGoods(Long pcgId);

    /**
     * deleteGoods
     * @param pcgId
     */
    public void deleteGoods(Long pcgId);

    /**
     * searchByName
     * @param name
     * @return
     */
    public List<PlatformCouponGoodsEntity> searchByName(String name);
    
    /**
     * findPage
     * @param name
     * @param pcgStatus
     * @param pageSize
     * @param pageIndex
     * @return
     */
    public Page<PlatformCouponGoodsEntity> findPage(String name,Integer pcgStatus,int pageSize,int pageIndex);
    
    /**
     * editPCGSwitches
     * @param pcgId
     * @param switches
     */
    public void editPCGSwitches(Long pcgId,Long switches);
}

