/**
 * Project Name:goods-center-biz File Name:GoodsDirectionalConfigServiceImpl.java Package
 * Name:cn.com.duiba.goods.center.biz.service.impl Date:2016年6月28日上午11:17:13 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.goods.center.biz.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.dao.GoodsDirectionalConfigDao;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;

/**
 * ClassName:GoodsDirectionalConfigServiceImpl <br/>
 * Date: 2016年6月28日 上午11:17:13 <br/>
 * 
 * @author wubo
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class GoodsDirectionalConfigServiceImpl implements GoodsDirectionalConfigService {

    @Autowired
    private GoodsDirectionalConfigDao goodsDirectionalConfigDao;
    @Autowired
	private StringRedisTemplate stringRedisTemplate;

    @Override
    public GoodsDirectionalConfigEntity find(long id) {
        return this.goodsDirectionalConfigDao.selectById(id);
    }

    @Override
    public List<GoodsDirectionalConfigEntity> findByGoods(GoodsTypeEnum gtype, long goodsId) {
        return this.goodsDirectionalConfigDao.selectByGoods(gtype.getGtype(), goodsId);
    }

    @Override
    public GoodsDirectionalConfigEntity findByGoodsAndApp(GoodsTypeEnum gtype, long goodsId, long appId) {
        return this.goodsDirectionalConfigDao.selectByGoodsAndApp(gtype.getGtype(), goodsId, appId);
    }
    @Override
    public boolean add(GoodsDirectionalConfigEntity entity) {
        boolean rs;
        int num = this.goodsDirectionalConfigDao.insert(entity);
        if (num == 1) {
            rs = true;
        } else {
            rs = false;
        }
        return rs;
    }

    @Override
    public boolean update(long id,Long stockId,Integer dayLimit,Integer minPrice) {
        int num;
        if(stockId==null){
            num = this.goodsDirectionalConfigDao.update(id,dayLimit,minPrice);
        }else{
            num = this.goodsDirectionalConfigDao.updateMore(id, stockId, dayLimit, minPrice);
        }
        if(num == 1){
        	 GoodsDirectionalConfigEntity gdce =  this.find(id);
             RedisFilterCache redisFilterCache=new RedisFilterCache(stringRedisTemplate);
             //清缓存
             redisFilterCache.clearFilterCache(redisFilterCache.getDirectionalRedisKey(gdce.getGoodsId(), gdce.getAppId()));
        	return true;
        }
        return false;
    }

    @Override
    public boolean remove(long id) {
        int num = this.goodsDirectionalConfigDao.delete(id);
        if(num == 1){
			GoodsDirectionalConfigEntity gdce = this.find(id);
			RedisFilterCache redisFilterCache = new RedisFilterCache(stringRedisTemplate);
			redisFilterCache.clearFilterCache(redisFilterCache.getDirectionalRedisKey(gdce.getGoodsId(), gdce.getAppId()));
            return true;
        }
        return false;
    }
    
    @Override
    public GoodsDirectionalConfigEntity findSharedByGoods(GoodsTypeEnum gtype, long goodsId) {
        return this.goodsDirectionalConfigDao.selectByGoodsAndApp(gtype.getGtype(), goodsId, 0L);
    }

    @Override
    public GoodsDirectionalConfigEntity findByGoodsAndAppIncludeShared(GoodsTypeEnum gtype, long goodsId, long appId) {
        GoodsDirectionalConfigEntity e=findByGoodsAndApp(gtype, goodsId, appId);
        if(e==null){
            e=findByGoodsAndApp(gtype, goodsId, 0);
        }
        return e;
    }
    

	@Override
	public Map<String, GoodsDirectionalConfigEntity> findByGoodsAll(GoodsTypeEnum gtype, List<Long> goodIds) {
		List<GoodsDirectionalConfigEntity> list =goodsDirectionalConfigDao.selectByGoodsAll(gtype,goodIds);
        Map<String, GoodsDirectionalConfigEntity> maps=new HashMap<>();
        for(GoodsDirectionalConfigEntity e:list){
            maps.put(e.getAppId()+"-"+e.getGoodsId(), e);
        }
		return maps;
	}

	@Override
	public DayLimitConfig getDayLimit(GoodsTypeEnum gtype, long goodsId, long appId) {
	    if(gtype!=GoodsTypeEnum.PLATFORM){
	        throw new RuntimeGoodsException(ErrorCode.E9999999, new Throwable("暂不支持该类型"));
	    }
	    long pcgId=goodsId;
	    //如果定向App每日限量库存，先加销量，再兑换
        Integer dayLimit=null;
        GoodsDirectionalConfigEntity e=findByGoodsAndApp(GoodsTypeEnum.PLATFORM, pcgId, appId);
        
        if(e!=null ){//如果有记录，根据记录上的值来继续
            if(e.getDayLimit()!=null){
                dayLimit=e.getDayLimit();
            }
        }else{//如果没有记录，根据共享记录的值来继续
            e=findSharedByGoods(GoodsTypeEnum.PLATFORM, pcgId);
            if(e!=null && e.getDayLimit()!=null){
                dayLimit=e.getDayLimit();
            }
        }
        if(dayLimit==null){
            return null;
        }else{
            return new DayLimitConfig(dayLimit, e);
        }
	}
	
	/**
	 * DayLimitConfig
	 */
	public static final class DayLimitConfig{
	    private Integer dayLimit;
	    private GoodsDirectionalConfigEntity config;
	    
	    /**
	     * DayLimitConfig
	     * @param dayLimit
	     * @param config
	     */
	    public DayLimitConfig(Integer dayLimit,GoodsDirectionalConfigEntity config){
	        this.dayLimit=dayLimit;
	        this.config=config;
	    }
        
        public Integer getDayLimit() {
            return dayLimit;
        }
        
        public void setDayLimit(Integer dayLimit) {
            this.dayLimit = dayLimit;
        }
        
        public GoodsDirectionalConfigEntity getConfig() {
            return config;
        }
        
        public void setConfig(GoodsDirectionalConfigEntity config) {
            this.config = config;
        }
	    
	    
	}
}
