package cn.com.duiba.goods.center.biz.service.impl;

import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.com.duiba.goods.center.api.remoteservice.constant.CacheConstants;
import cn.com.duiba.goods.center.api.remoteservice.dto.SellerDto;
import cn.com.duiba.goods.center.biz.dao.SellerDao;
import cn.com.duiba.goods.center.biz.service.SellerSevice;
import cn.com.duiba.goods.center.biz.util.DataSource;
import cn.com.duiba.goods.center.biz.util.RedisKeyFactory;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.utils.SecurityUtils;

/**
 * 商家安全签名
 */
@Service
public class SellerSeviceImpl implements SellerSevice {

	@Autowired
	private SellerDao sellerDao;

	@Resource(name = "redisTemplate")
	private AdvancedCacheClient advancedCacheClient;

	@Resource(name = "stringRedisTemplate03")
	private AdvancedCacheClient advancedCacheClient03;

	@Transactional(value = DataSource.CREDITS)
	@Override
	public Boolean insertSeller(SellerDto sellerDto) {
		if (sellerDto == null) {
			return false;
		}
		sellerDto.setValidFlag(SellerDto.VALID_FLAG_TRUE);
		// 插入
		sellerDao.insertSeller(sellerDto);
		// 通过ID+当前时间生成秘钥
		String key = SecurityUtils.encode2StringBySHA(sellerDto.getId() + new Date().toString());
		sellerDto.setSafeSign(key);
		// 更新生成的秘钥
		sellerDao.update(sellerDto);
		return true;
	}

	@Override
	public Boolean deleteSeller(Long id) {
		int result = sellerDao.deleteSeller(id);
		if (result > 0) {
			remove(id);
			return true;
		}
		return false;
	}

	@Override
	public List<SellerDto> findAll(SellerDto sellerDto, Integer offset, Integer max) {
		return sellerDao.findAll(sellerDto, offset, max);
	}

	@Override
	public Integer findCount(SellerDto sellerDto) {
		return sellerDao.findCount(sellerDto);
	}

	@Override
	public SellerDto findById(Long id) {
		String key = RedisKeyFactory.K207 + String.valueOf(id);
		SellerDto sellerDto = advancedCacheClient.get(key);
		if (sellerDto == null) {
			sellerDto = sellerDao.findById(id);
			advancedCacheClient.set(key, sellerDto, 60, TimeUnit.SECONDS);
		}
		return sellerDto;
	}

	private void remove(Long id) {
		String key = RedisKeyFactory.K207 + String.valueOf(id);
		advancedCacheClient.remove(key);
		advancedCacheClient03.remove(CacheConstants.KEY_SELLER_BY_ID + id);
	}
}
