package cn.com.duiba.goods.center.biz.service.item;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.AddrLimitDto;
import cn.com.duiba.goods.center.biz.cache.IPCache;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;

/**
 * 
 * 商品地域限制
 *
 */
public interface AddrLimitService {

	/**
	 * 查询APP商品地域限制
	 * 
	 * @param appItemId
	 * @return
	 */
	public List<AddrLimitDto> findAddrLimitByAppItemId(Long appItemId);

	/**
	 * 批量查询APP商品地域限制
	 * 
	 * @param appItemIds
	 * @return
	 */
	public List<AddrLimitDto> findAddrLimitByAppItemIds(List<Long> appItemIds);

	/**
	 * 查询兑吧商品地域限制
	 * 
	 * @param itemId
	 * @return
	 */
	public List<AddrLimitDto> findAddrLimitByItemId(Long itemId);

	/**
	 * 批量查询兑吧商品地域限制
	 * 
	 * @param itemIds
	 * @return
	 */
	public List<AddrLimitDto> findAddrLimitByItemIds(List<Long> itemIds);

	/**
	 * 查询APP商品限制类型
	 * 
	 * @param appItemId
	 * @return
	 */
	public Integer findTypeByAppItemId(Long appItemId);

	/**
	 * 查询兑吧商品限制类型
	 * 
	 * @param itemId
	 * @return
	 */
	public Integer findTypeByItemId(Long itemId);

	/**
	 * 添加地域限制
	 * 
	 * @param addrLimitList
	 * @return
	 */
	public Integer batchInsertAddrLimit(List<AddrLimitDto> addrLimitList);

	/**
	 * 删除商品地域限制
	 * 
	 * @param itemId
	 * @param appItemId
	 * @return 
	 */
	public Integer deleteAddrLimit(Long itemId, Long appItemId);

	/**
	 * 查询IP
	 * 
	 * @param ipLong
	 * @return
	 */
	public IPCache findCodeByIpLong(Long ipLong);
	
    /**
     * 自有优惠券，实物添加地域限制
     */
    public void devAppItemAddAddrLimit(AppItemEntity appItem, String limitType, String limitAreas);
    
}
