package cn.com.duiba.goods.center.biz.service.item;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;

/**
 * AppItemService
 */
public interface AppItemService {

    /**
     * 根据ID查询应用商品信息
     *
     * @param id
     * @return
     */
    public AppItemEntity find(Long id);

    /**
     * 根据ID集合查询应用商品信息
     *
     * @param ids
     * @return
     */
    public List<AppItemEntity> findByIds(List<Long> ids);

    /**
     * 根据ItemId查询
     *
     * @param appId
     * @param itemId
     * @return
     */
    public AppItemEntity findByAppIdAndItemId(Long appId, Long itemId);
    
    /**
     *  统计开发者入库数
     * @param itemId
     * @return
     */
    public Integer findCountByItemId(Long itemId);

    /**
     * 根据ItemIds查询
     *
     * @param appId
     * @param itemIds
     * @return
     */
    public List<AppItemEntity> findByAppIdAndItemIds(Long appId, List<Long> itemIds);

    /**
     * 创建商品
     *
     * @param appItemEntity
     * @return
     */
    public Long insert(AppItemEntity appItemEntity);

    /**
     * 修改商品
     *
     * @param appItemEntity
     * @return
     */
    public Boolean update(AppItemEntity appItemEntity);

    /**
     * 删除商品
     *
     * @param appId
     * @param appItemId
     * @return
     */
    public Boolean delete(Long appId, Long appItemId);

    /**
     * 批量删除商品
     *
     * @param appId
     * @param appItemId
     * @return
     */
    public Integer deleteByIds(Long appId, List<Long> appItemId);

    /**
     * 修改状态
     *
     * @param appId
     * @param appItemId
     * @param status    off:下架 on:上架
     * @return
     */
    public Boolean updateStatus(Long appId, Long appItemId, String status);

    /**
     * 批量修改状态
     *
     * @param appId
     * @param appItemIds
     * @param status     off:下架 on:上架
     * @return
     */
    public Integer updateStatusByIds(Long appId, List<Long> appItemIds, String status);

    /**
     * 减一个库存
     *
     * @param appId
     * @param appItemId
     * @return
     */
    public Boolean decrStock(Long appId, Long appItemId);

    /**
     * 增加一个库存
     *
     * @param appItemId
     * @param bizId
     * @return
     */
    public Boolean incrStock(Long appItemId);

    /**
     * 编辑商品，增加库存
     *
     * @param appId
     * @param appItemId
     * @param number
     * @return
     */
    public Boolean appendStock(Long appId, Long appItemId, Long number);

    /**
     * 编辑商品，减少库存
     *
     * @param appId
     * @param appItemId
     * @param number
     * @return
     */
    public Boolean deductStock(Long appId, Long appItemId, Long number);

    /**
     * 修改库存和过期时间
     *
     * @param appItemId
     * @param totalStock
     * @param validEndDate
     * @return
     */
    public int updateRemainingAndvalidEndDate(Long appItemId, Long totalStock, Date validEndDate);
    
    /**
     * 修改优惠券商品类型
     * @param appItemId
     * @param subType
     * @return
     */
    public int updateSubTypeById(Long appItemId, Integer subType);
    
    /**
     * 修改过期时间
     * @param appItemId
     * @param validEndDate
     * @return
     */
    public int updateValidEndDateById(Long appItemId, Date validEndDate);

    /**
     * 修改EXPIED为null
     *
     * @param itemId
     * @return
     */
    public int updateExpiedAppItem(Long itemId);

    /**
     * 修改EXPIED为null
     *
     * @param appItemId
     * @return
     */
    public int updateExpiedAppItemById(Long appItemId);

    /**
     * 查询appIds根据活动id
     *
     * @param activityId
     * @param type
     * @return
     */
    public List<Long> findAppIdsByInActivityId(Long activityId, Integer type);

    /**
     * 查询appIds根据活动id
     *
     * @param relationId
     * @return
     */
    public List<Long> findAppIdsByActivityId(Long relationId);

    /**
     * 根据兑吧商品ID批量查询APPID
     *
     * @param longs
     * @return
     */
    public List<Long> findAppIdByItemIds(List<Long> longs);

    /**
     * 批量查询APPID
     *
     * @param longs
     * @return
     */
    public List<Long> findAppIdsByIds(List<Long> longs);

    /**
     * 得到普通上架项中的最大的权重
     *
     * @param appId
     * @return
     */
    public int findAppMaxPayload(Long appId);

    /**
     * 清理缓存
     *
     * @param appItemId
     */
    public void removeCache(Long appItemId);

    /**
     * 修改状态根据SourceRelationId;
     *
     * @param status
     * @param delete
     * @param oids
     * @return
     */
    public int updateStatusByActivityIds(String status, Boolean delete, List<Long> oids);

    /**
     * updateStatusByActivityId
     * @param status
     * @param delete
     * @param activityId
     * @param type
     * @return
     */
    public Integer updateStatusByActivityId(String status, Boolean delete, Long activityId, Integer type);

    /**
     * 根据SourceIds和SourceTypes批量查询AppItemId
     *
     * @param sourceIds
     * @param sourceTypes
     * @param appId       可以为null
     * @return
     */
    public List<Long> findIDBySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes, Long appId);

    /**
     * findBySourceIdsAndSourceTypes
     * @param sourceIds
     * @param sourceTypes
     * @param appId
     * @return
     */
    public List<AppItemEntity> findBySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes, Long appId);

    /**
     * 查询当前已置顶的商品appItemId,按权重倒叙排序
     *
     * @param appId
     * @return
     */
    public List<Long> findTopAppItemIdsDescByPayload(Long appId);

    /**
     * 更新商品权重
     *
     * @param appId
     * @param appItemId
     * @param payload
     * @return
     */
    public int updateAppItemPayload(Long appId, Long appItemId, Integer payload);

    /**
     * 自动修复兑吧已经禁用的商品 比如： 商品被添加到AppItem，而后兑吧禁用或者删除了该商品，
     * 此时在AppItem库中，该商品还是上架状态。 此时进行修复，将该商品标记为下架状态
     * 使用场景：当开发者在后台调整首页兑换项顺序时触发该程序
     */
    public int updateOfflineAppItem4Disable(Long appId);
    
	/**
	 * 根据兑吧商品ID查询开发者上架和的商品
	 * 
	 * @param itemId
	 * @return
	 */
	public List<AppItemDto> findOnShelfByItemId(Long itemId);
	
	/**
	 * 上架或者下架
	 * @param id
	 * @param status
	 * @param deleted
	 * @param payload
	 * @param homeDisplay
	 */
	public Integer standUpOrDownAppItem(Long id, String status, Boolean deleted, Integer payload, Boolean homeDisplay);
	
	/**
	 * 更新活动工具兑换项入口
	 * @param id
	 * @param title
	 * @param smallImage
	 * @param whiteImage
	 * @param credits
	 * @param customPrice
	 * @param logo
	 * @param operationsType
	 */
	public Integer updateHdtoolAppItem(Long id, String title, String smallImage, String whiteImage, Long credits, String customPrice, String logo, Integer operationsType);
	
    /**
     * 更新专题活动主推兑换项属性
     * @param id
     * @param title
     * @param logo
     * @param smallImage
     * @param whiteImage
     * @param bannerImage
     * @param credits
     * @param subtitle
     */
    public int updateMainPushAppItem(Long id, String title, String logo, String smallImage, String whiteImage, String bannerImage, Long credits, String subtitle);
    
    /**
     * 查询活动兑换项
     * @param sourceType
     * @param sourceRelationId
     * @param deleted
     * @return
     */
    public List<AppItemDto> findAllBySourceTypeAndRelationIdAndDeleted(Integer sourceType, Long sourceRelationId, Boolean deleted);
    
    /**
     * 分页查询
     * @param queryPublish
     * @return
     */
    public Page<AppItemDto> findPublishItemLimit(Map<String, Object> queryPublish);
    
    /**
     * 分页查询
     * @param params
     * @return
     */
    public Page<AppItemDto> findByLimit(Map<String, Object> params);
    
    /**
     * 根据类型查询
     * 
     * @param appId
     * @param types
     * @return
     */
    public List<AppItemDto> findAllByAppIdAndInType(Long appId, String[] types);

    /**
     * 获取库存不足的兑换项的数量
     */
    public Integer getRemaining0Count(Long appId);
    
    /**
     * 获取上架中的兑换项数量，不包含活动兑换项入口
     */
    public Integer findOnlineCount(Long appId);
    
    /**
     * 获取直充类的ID,没有则添加
     * @param type
     * @param appId
     * @return
     */
    public Long getOrAddAppItemId(String type, Long appId, Long appCreditsRate);
    
    /**
     * 查询虚拟商品
     * @param appId
     * @return
     */
    public List<AppItemDto> findAllUpVirtaulAppItems(Long appId);
    
    /**
     * 修改优惠券商品
     * @param appItem
     * @param exchangeLimit
     * @param arealimitSwitch
     * @param arealimitType
     * @param arealimitAreas
     * @param usePrompt
     * @param btnText
     */
    public void doUpdateCoupon(AppItemEntity appItem, String exchangeLimit, String arealimitSwitch, String arealimitType, String arealimitAreas, String usePrompt, String btnText);
    
    /**
     * 更新运营活动状态
     */
    public void updateOperationsTypeById(Long id, Integer operationsType);
    
    /**
     * 批量删除开发者商品
     * @param appId
     * @param appItemIds
     */
    public boolean doBatchDel(Long appId, List<Long> appItemIds);
    
    /**
     * 批量上架
     * @param appId
     * @param virtualExchangeUrl
     * @param appItemIds
     * @return
     */
    public int bathcStandUp(Long appId, String virtualExchangeUrl, List<Long> appItemIds);
    
    /**
     * 新应用添加一个测试专用优惠券
     * @param appId
     */
    public Long addTestCoupon(Long appId);
    
    /**
     * 修改只有实物
     * @param appItem
     * @param preRemaining
     * @param remaining
     * @param exchangeLimit
     * @param arealimitSwitch
     * @param arealimitType
     * @param arealimitAreas
     */
    public Boolean doUpdateOwnerObject(AppItemDto appItem, Integer preRemaining, Integer remaining, String exchangeLimit, String arealimitSwitch, String arealimitType, String arealimitAreas);
    
    /**
     * 获取app下所有上架的可用的自有商品
     * 
     * @param appId
     * @param types 类型
     * @param warnLine 库存预警线(实物,虚拟商品)
     * @return
     */
    public List<Long> findSelfAppItemIdsByAppId(Long appId,List<String> types,Integer warnLine);
    
}
