package cn.com.duiba.goods.center.biz.service.item.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AmbExpressTemplateOptionDto;
import cn.com.duiba.goods.center.biz.dao.item.AmbExpressTemplateOptionDAO;
import cn.com.duiba.goods.center.biz.service.item.AmbExpressTemplateOptionService;

/**
 * 加钱购运费模版
 */
@Service
public class AmbExpressTemplateOptionServiceImpl implements AmbExpressTemplateOptionService {

	@Autowired
	private AmbExpressTemplateOptionDAO ambExpressTemplateOptionDAO;

	@Override
	public AmbExpressTemplateOptionDto find(Long id) {
		return ambExpressTemplateOptionDAO.find(id);
	}

	@Override
	public void insert(AmbExpressTemplateOptionDto entity) {
		ambExpressTemplateOptionDAO.insert(entity);
	}

	@Override
	public int update(AmbExpressTemplateOptionDto entity) {
		return ambExpressTemplateOptionDAO.update(entity);
	}

	@Override
	public List<AmbExpressTemplateOptionDto> findByTemplateId(Long expressTemplateId) {
		return ambExpressTemplateOptionDAO.findByTemplateId(expressTemplateId);
	}

	@Override
	public List<AmbExpressTemplateOptionDto> findByTemplateIds(List<Long> ids) {
		return ambExpressTemplateOptionDAO.findByTemplateIds(ids);
	}

	@Override
	public int deleteOptionByTemplateId(Long expressTemplateId) {
		return ambExpressTemplateOptionDAO.deleteOptionByTemplateId(expressTemplateId);
	}

	@Override
	public int batchInsert(List<AmbExpressTemplateOptionDto> dtos) {
		return ambExpressTemplateOptionDAO.batchInsert(dtos);
	}

}
