package cn.com.duiba.goods.center.biz.service.item.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.constant.CacheConstants;
import cn.com.duiba.goods.center.biz.dao.item.AppBannerDao;
import cn.com.duiba.goods.center.biz.service.item.AppBannerService;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;

/**
 * APPBanner
 */
@Service
public class AppBannerServiceImpl implements AppBannerService{
	
    @Resource(name="stringRedisTemplate03")
    private StringRedisTemplate stringRedisTemplate;
    
    @Resource(name="stringRedisTemplate03")
    private AdvancedCacheClient advancedCacheClient;
	
	@Autowired
	private AppBannerDao appBannerDao;

	@Override
	public Integer disableByAppIdAndAppItemId(Long appId, Long appItemId) {
		List<Long> ids = appBannerDao.findIdsByAppIdAndAppItemId(appId, appItemId);
		int ret = appBannerDao.disableByAppIdAndAppItemId(appId, appItemId);
		List<String> keys = new ArrayList<>();
		for (Long id : ids) {
			keys.add(getCacheKeyById(id));
		}
		stringRedisTemplate.delete(keys);
		return ret;
	}
	
	@Override
    public void removeCacheByAppId(Long appId){
        advancedCacheClient.remove(getCacheKeyByAppId(appId));
		String cacheKey = CacheConstants.MS_HOME_ITEM + "-" + appId;
		advancedCacheClient.set(cacheKey, System.currentTimeMillis(), 3600, TimeUnit.SECONDS);
    }

    private String getCacheKeyByAppId(Long appId){
        return CacheConstants.KEP_APP_BANNERS + appId;
    }
    
    private String getCacheKeyById(Long id){
        return CacheConstants.KEY_APP_BANNER_BY_ID + id;
    }

}
