package cn.com.duiba.goods.center.biz.service.item.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.biz.cache.AppItemCache;
import cn.com.duiba.goods.center.biz.cache.EventHomeCache;
import cn.com.duiba.goods.center.biz.dao.item.AppItemDao;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.service.item.HomeAppItemService;
import cn.com.duiba.goods.center.biz.util.RedisKeyFactory;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.SecurityUtils;

import com.alibaba.fastjson.JSONObject;

/**
 * Created by liuyao on 2016/11/16.
 */
@Service
public class HomeAppItemServiceImpl implements HomeAppItemService {

	@Resource(name = "redisTemplate")
	private AdvancedCacheClient advancedCacheClient;
	@Autowired
	private AppItemDao appItemDao;
	@Autowired
	private EventHomeCache eventHomeCache;

	@Override
	public List<AppItemDto> findhomeAppItemNeed(Long appId) {
		return appItemDao.findhomeAppItemNeed(appId);
	}

	@Override
	public List<AppItemDto> findBannerIconAppItemByCache(Long appId, List<Long> appItemIds) {
		List<AppItemEntity> entitys = appItemDao.findByIds(appItemIds);
		return BeanUtils.copyList(entitys, AppItemDto.class);
	}

	@Override
	public List<AppItemDto> findByLimitCache(Long appId, Map<String, Object> queryParams) {
		if (appId == null) {
			throw new RuntimeGoodsException(ErrorCode.E0404004);
		}
		queryParams.put("appId", appId);
		String queryJson = JSONObject.toJSONString(queryParams);
		String keyStr = RedisKeyFactory.k208 + SecurityUtils.encode2StringByMd5(queryJson);
		AppItemCache cache = advancedCacheClient.get(keyStr);
		Long memTime = eventHomeCache.getAppTimestamp(appId);
		if (cache == null) {
			cache = new AppItemCache(appItemDao.findByLimit(queryParams));
			advancedCacheClient.set(keyStr, cache, 5, TimeUnit.SECONDS);
			return cache.getAppItems();
		}
		if (memTime != null && cache.getCacheTime() < memTime) {
			cache = new AppItemCache(appItemDao.findByLimit(queryParams));
			advancedCacheClient.set(keyStr, cache, 5, TimeUnit.SECONDS);
		}
		return cache.getAppItems();
	}

}
