package cn.com.duiba.goods.center.biz.service.item.impl;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.com.duiba.goods.center.biz.dao.item.ItemStockManualChangeDao;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.entity.ItemStockManualChangeEntity;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemStockManualChangeService;
import cn.com.duiba.goods.center.biz.util.DataSource;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.item.domain.dataobject.ItemStockManualChangeDO;

/**
 * Created by wenqi.huang on 16/5/4.
 */
@Service
public class ItemStockManualChangeServiceImpl implements ItemStockManualChangeService {

	@Resource
	private ItemStockManualChangeDao itemStockManualChangeDao;
	@Autowired
	private AppItemService appItemService;
	@Autowired
	private ItemService itemService;

	@Override
	@Transactional(value = DataSource.CREDITS)
	public boolean updateRemainingByEdit(Long appItemId, Integer preRemaining, Integer requiredRemaining) {
		if (preRemaining == null || requiredRemaining == null) {
			throw new RuntimeGoodsException(ErrorCode.E0404004);
		}
		int differRemaining = requiredRemaining - preRemaining;
		if (differRemaining == 0) {
			return true;
		}
		if (differRemaining > 0) {
			return addStockQuantity(appItemId, Math.abs(differRemaining));
		}
		if (differRemaining < 0) {
			return reduceStockQuantity(appItemId, Math.abs(differRemaining));
		}
		return false;
	}

	/**
	 * 兑吧商品加库存 只有实物和虚拟商品
	 * 
	 * @param appItemId
	 * @param quantity
	 * @return
	 * @throws Exception
	 */
	private boolean addStockQuantity(Long appItemId, Integer quantity) {

		AppItemEntity appItem = appItemService.find(appItemId);
		if (null == appItem) {
			throw new RuntimeGoodsException(ErrorCode.E0404004);
		}
		if (!appItem.getType().equals(ItemDO.TypeObject) && !appItem.getType().equals(ItemDO.TypeVirtual)) {
			throw new RuntimeGoodsException(ErrorCode.E0202008);
		}

		boolean result = appItemService.appendStock(appItem.getAppId(), appItemId, Long.valueOf(quantity));
		if (!result) {
			throw new RuntimeGoodsException(ErrorCode.E0102002);
		}

		ItemStockManualChangeEntity itemStockChange = new ItemStockManualChangeEntity(true);
		itemStockChange.setRelationId(appItemId);
		itemStockChange.setRelationType(ItemStockManualChangeDO.TYPE_DEV_ITEM);
		itemStockChange.setBeforeStock((long) appItem.getRemaining());
		itemStockChange.setAfterStock((long) (appItem.getRemaining() + quantity));
		itemStockChange.setChangeKind(ItemStockManualChangeDO.KIND_ADD);
		itemStockChange.setChangeQuantity((long) quantity);

		itemStockManualChangeDao.insert(itemStockChange);
		return true;
	}

	/**
	 * 兑吧商品减库存 只有实物和虚拟商品
	 * 
	 * @param appItemId
	 * @param quantity
	 * @return
	 * @throws Exception
	 */
	private boolean reduceStockQuantity(Long appItemId, Integer quantity) {
		AppItemEntity appItem = appItemService.find(appItemId);
		if (null == appItem) {
			throw new RuntimeGoodsException(ErrorCode.E0404004);
		}
		if (!appItem.getType().equals(ItemDO.TypeObject) && !appItem.getType().equals(ItemDO.TypeVirtual)) {
			throw new RuntimeGoodsException(ErrorCode.E0202008);
		}

		boolean result = appItemService.deductStock(appItem.getAppId(), appItemId, Long.valueOf(quantity));
		if (!result) {
			throw new RuntimeGoodsException(ErrorCode.E0102002);
		}

		ItemStockManualChangeEntity itemStockChange = new ItemStockManualChangeEntity(true);
		itemStockChange.setRelationId(appItemId);
		itemStockChange.setRelationType(ItemStockManualChangeDO.TYPE_DEV_ITEM);
		itemStockChange.setBeforeStock((long) appItem.getRemaining());
		itemStockChange.setAfterStock((long) (appItem.getRemaining() - quantity));
		itemStockChange.setChangeKind(ItemStockManualChangeDO.KIND_SUB);
		itemStockChange.setChangeQuantity((long) quantity);

		itemStockManualChangeDao.insert(itemStockChange);
		return true;
	}

	@Override
	@Transactional(value = DataSource.CREDITS)
	public boolean updateRemainingByEditItem(Long appItemId, Integer preRemaining, Integer requiredRemaining) {
		if (preRemaining == null || requiredRemaining == null) {
			throw new RuntimeGoodsException(ErrorCode.E0404004);
		}
		int differRemaining = requiredRemaining - preRemaining;
		if (differRemaining == 0) {
			return true;
		}
		if (differRemaining > 0) {
			return this.addStockQuantity_item(appItemId, Math.abs(differRemaining));
		}
		if (differRemaining < 0) {
			return this.reduceStockQuantity_item(appItemId, Math.abs(differRemaining));
		}
		return false;
	}

	private boolean addStockQuantity_item(Long itemId, Integer quantity) {
		ItemEntity item = itemService.find(itemId);
		if (null == item) {
			throw new RuntimeGoodsException(ErrorCode.E0404004);
		}
		if (!item.getType().equals(ItemDO.TypeObject) && !item.getType().equals(ItemDO.TypeVirtual)) {
			throw new RuntimeGoodsException(ErrorCode.E0202008);
		}

		boolean result = itemService.appendStock(itemId, Long.valueOf(quantity));
		if (!result) {
			throw new RuntimeGoodsException(ErrorCode.E0102002);
		}

		ItemStockManualChangeEntity itemStockChange = new ItemStockManualChangeEntity(true);
		itemStockChange.setRelationId(itemId);
		itemStockChange.setRelationType(ItemStockManualChangeDO.TYPE_DUIBA_ITEM);
		itemStockChange.setBeforeStock((long) item.getRemaining());
		itemStockChange.setAfterStock((long) (item.getRemaining() + quantity));
		itemStockChange.setChangeKind(ItemStockManualChangeDO.KIND_ADD);
		itemStockChange.setChangeQuantity((long) quantity);

		itemStockManualChangeDao.insert(itemStockChange);
		return true;
	}

	private boolean reduceStockQuantity_item(Long itemId, Integer quantity) {
		ItemEntity item = itemService.find(itemId);
		if (null == item) {
			throw new RuntimeGoodsException(ErrorCode.E0404004);
		}
		if (!item.getType().equals(ItemDO.TypeObject) && !item.getType().equals(ItemDO.TypeVirtual)) {
			throw new RuntimeGoodsException(ErrorCode.E0202008);
		}

		boolean result = itemService.deductStock(itemId, Long.valueOf(quantity));
		if (!result) {
			throw new RuntimeGoodsException(ErrorCode.E0102002);
		}

		ItemStockManualChangeEntity itemStockChange = new ItemStockManualChangeEntity(true);
		itemStockChange.setRelationId(itemId);
		itemStockChange.setRelationType(ItemStockManualChangeDO.TYPE_DUIBA_ITEM);
		itemStockChange.setBeforeStock((long) item.getRemaining());
		itemStockChange.setAfterStock((long) (item.getRemaining() - quantity));
		itemStockChange.setChangeKind(ItemStockManualChangeDO.KIND_SUB);
		itemStockChange.setChangeQuantity((long) quantity);

		itemStockManualChangeDao.insert(itemStockChange);
		return true;
	}
}
