/**
 * Project Name:goods-center-biz
 * File Name:PcgSalesVolumeService.java
 * Package Name:cn.com.duiba.goods.center.biz.service.stock
 * Date:2016年8月3日下午6:00:56
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service.stock;

import java.util.List;
import java.util.Map;

import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;


/**
 * ClassName:PcgSalesVolumeService <br/>
 * Function: 平台券商品定向销量相关服务. <br/>
 * Date:     2016年8月3日 下午6:00:56 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface PcgDirectionalSalesVolumeService {
    /**
     * 查询平台券定向每日销量
     *
     * @author xuhengfei
     * @param pcgId 平台券商品id
     * @param directionId 定向配置主键id
     * @return 今日销量
     * @since JDK 1.6
     */
    public Long findSaleCountToday(long pcgId,long directionId);
    
    /**
     * 批量查询平台券定向每日销量
     * @param list
     * @return
     */
    public Map<String, Long> findSaleCountTodayBatch(List<GoodsDirectionalConfigEntity> list); 
    
    /**
     * 平台券定向App销量+1 
     *
     * @author xuhengfei
     * @param pcgId 平台券商品id
     * @param directionId 定向配置主键id
     * @param orderNum 业务订单号
     * @param dayLimit 每日最大销量
     * @return 是否成功
     * @since JDK 1.6
     */
    public boolean addSaleToday(long pcgId,long directionId,String orderNum,int dayLimit);
    /**
     * 平台券定向App销量回滚
     *
     * @author xuhengfei
     * @param pcgId 平台券商品id
     * @param directionId 定向配置主键id
     * @param orderNum 业务编号
     * @return
     * @since JDK 1.6
     */
    public boolean rollbackSale(long pcgId,long directionId,String orderNum);
}

