package cn.com.duiba.goods.center.biz.service.stock.impl;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemAppSpecifyDto;
import cn.com.duiba.goods.center.biz.dao.item.ItemAppSpecifyDao;
import cn.com.duiba.goods.center.biz.entity.ItemAppSpecifyEntity;
import cn.com.duiba.goods.center.biz.service.stock.ItemAppSpecifyService;
import cn.com.duiba.goods.center.biz.util.CacheConstants;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by liuyao on 2017/1/11.
 */
@Service
public class ItemAppSpecifyServiceImpl implements ItemAppSpecifyService {
    @Autowired
    private ItemAppSpecifyDao itemAppSpecifyDao;
    @Resource(name="stringRedisTemplate03")
    private AdvancedCacheClient advancedCacheClient;

    @Override
    public List<ItemAppSpecifyDto> findSpecifyByItemIdsAndAppId(List<Long> itemIds, Long appId) {
        if(itemIds.isEmpty()){
            return Collections.emptyList();
        }
        List<ItemAppSpecifyEntity> list = itemAppSpecifyDao.findSpecifyByItemIdsAndAppId(itemIds,appId);

        return BeanUtils.copyList(list,ItemAppSpecifyDto.class);
    }

    @Override
    public ItemAppSpecifyDto findByItemIdAndAppId(final Long itemId, final Long appId){
        //TODO 等这个表所有操作迁移过来后把这个缓存时间改大到300秒
        return advancedCacheClient.getWithCacheLoader(getCacheKeyByItemIdAndAppId(itemId, appId), 1, TimeUnit.SECONDS, true, new CacheLoader<ItemAppSpecifyDto>() {
            public ItemAppSpecifyDto load(){
                return BeanUtils.copy(itemAppSpecifyDao.findByItemIdAndAppId(itemId, appId),ItemAppSpecifyDto.class);
            }
        });
    }

    private String getCacheKeyByItemIdAndAppId(Long itemId, Long appId){
        return CacheConstants.KEY_ITEM_APP_SPECIFY_BY_ITEMID_APPID + itemId + "_" + appId;
    }

	@Override
	public List<Long> findNOSpecify4App(Long appId) {
		return itemAppSpecifyDao.findNOSpecify4App(appId);
	}
}
