package cn.com.duiba.goods.center.biz.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * IP工具类
 */
public class IpUtil {

	private static final Logger LOG = LoggerFactory.getLogger(IpUtil.class);

	private IpUtil() {

	}

	/**
	 * 工具方法，把字符串IP转换成数字，方便搜索
	 * 
	 * @param strip
	 * @return
	 */
	public static Long convertIpLong(String strip) {
		try {
			long[] ip = new long[4];
			int position1 = strip.indexOf('.');
			int position2 = strip.indexOf('.', position1 + 1);
			int position3 = strip.indexOf('.', position2 + 1);
			ip[0] = Long.parseLong(strip.substring(0, position1));
			ip[1] = Long.parseLong(strip.substring(position1 + 1, position2));
			ip[2] = Long.parseLong(strip.substring(position2 + 1, position3));
			ip[3] = Long.parseLong(strip.substring(position3 + 1));
			return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];// ip1*256*256*256+ip2*256*256+ip3*256+ip4
		} catch (Exception e) {
			LOG.error("convertIpLong", e);
			return null;
		}
	}
}
