package cn.com.duiba.goods.center.biz.bo.item.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.ACGStockDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.ItemKeyUtils;
import cn.com.duiba.goods.center.biz.bo.item.ItemKeyBo;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.HomeAppItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemKeyService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.wolf.utils.BeanUtils;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;

/**
 * Created by liuyao on 2016/11/16.
 */
@Service
public class ItemKeyBoImpl implements ItemKeyBo {
    @Autowired
    private HomeAppItemService homeAppItemService;
    @Autowired
    private AppItemService appItemService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private ItemKeyService itemKeyService;

    @Override
    public List<ItemKeyDto> findHomeItemKeyCacheList(Long appId) {
        return findHomeItemKeyList(appId);
    }

    @Override
    public List<ItemKeyDto> findHomeItemKeyByAppIdAndLimitCount(long appId, int limitCount) {
        List<AppItemDto> appItems = homeAppItemService.findHomeItemKeyByAppIdAndLimitCount(appId, limitCount);
        return transformAppItemList(appItems);
    }

    @Override
    public List<ItemKeyDto> findHomeItemKeyList(Long appId) {
        List<AppItemDto> appItems = homeAppItemService.findhomeAppItemNeed(appId);
        return transformAppItemList(appItems);
    }

    /**
     * 设置库存
     * @param itemKeyDtos
     */
    private void batchFindGoodsCouponStock(List<ItemKeyDto> itemKeyDtos) {
        List<Long> appItemIds = new ArrayList<>();
        List<Long> itemIds = new ArrayList<>();
        for (ItemKeyDto itemKey : itemKeyDtos) {
            if (ItemKeyUtils.isGoodsCoupon(itemKey)) {
                if (itemKey.isSelfAppItemMode()) {
                    appItemIds.add(itemKey.getAppItem().getId());
                } else if (itemKey.isDuibaAppItemMode() || itemKey.isItemMode()) {
                    itemIds.add(itemKey.getItem().getId());
                }
            }
        }
        Table<GoodsTypeEnum,Long,Long> stockTable = HashBasedTable.create();
		if (!appItemIds.isEmpty()) {
			List<ACGStockDto> stocks = goodsBatchService.findStockByGids(GoodsTypeEnum.APP, appItemIds);
			for(ACGStockDto stock : stocks){
                stockTable.put(GoodsTypeEnum.APP,stock.getAcgId(),stock.getStock());
			}
		}
		if (!itemIds.isEmpty()) {
			List<ACGStockDto> stocks = goodsBatchService.findStockByGids(GoodsTypeEnum.DUIBA, itemIds);
			for(ACGStockDto stock : stocks){
                stockTable.put(GoodsTypeEnum.DUIBA,stock.getAcgId(),stock.getStock());
			}
		}
        for (ItemKeyDto itemKey : itemKeyDtos) {
            if (!ItemKeyUtils.isGoodsCoupon(itemKey)) {
                continue;
            }
            if (itemKey.isSelfAppItemMode()) {
                Long stock = stockTable.get(GoodsTypeEnum.APP,itemKey.getAppItem().getId());
                if(stock!=null){
                	itemKey.getAppItem().setRemaining(stock.intValue());
                }
            } else if (itemKey.isDuibaAppItemMode() || itemKey.isItemMode()) {
                Long stock = stockTable.get(GoodsTypeEnum.DUIBA,itemKey.getItem().getId());
                if(stock!=null){
                	itemKey.getItem().setRemaining(stock.intValue());
                }
            }
        }
    }

	@Override
	public List<ItemKeyDto> transformAppItemList(List<AppItemDto> appItemList) {
		List<Long> itemIds = new ArrayList<>();
		for (AppItemDto appItem : appItemList) {
			if (appItem.getItemId() != null) {
				itemIds.add(appItem.getItemId());
			}
		}
		Map<Long, ItemDto> itemId2ItemMap = new HashMap<>();
		if (!itemIds.isEmpty()) {
			List<ItemDto> items = itemService.findHomeItems(itemIds);
			for (ItemDto item : items) {
				itemId2ItemMap.put(item.getId(), item);
			}
		}
		List<ItemKeyDto> itemKeys = new ArrayList<>();
		for (AppItemDto appItem : appItemList) {
			if (appItem.getItemId() == null) {
				itemKeys.add(new ItemKeyDto(appItem, null, appItem.getAppId()));
			} else {
				ItemDto item = itemId2ItemMap.get(appItem.getItemId());
				if (item == null || !item.getEnable() || item.getDeleted()) {
					continue;
				}
				itemKeys.add(new ItemKeyDto(appItem, item, appItem.getAppId()));
			}
		}
		// 设置商品中心优惠券库存
		batchFindGoodsCouponStock(itemKeys);
		return itemKeys;
	}

    @Override
    public List<ItemKeyDto> getBatchItemKeyByAppItemIds(List<Long> appItemIds) {
        List<AppItemEntity> list = appItemService.findByIds(appItemIds);
        List<AppItemDto> dtos = BeanUtils.copyList(list, AppItemDto.class);
        return transformAppItemList(dtos);
    }

    @Override
    public ItemKeyDto transformAppItem(AppItemDto appItem) {
        if(appItem==null){
            return null;
        }
        List<AppItemDto> appItemDtolist = Lists.newArrayList(appItem);
        return transformAppItemList(appItemDtolist).get(0);
    }

    @Override
    public List<ItemKeyDto> transformItemList(List<ItemDto> itemDtoList){
        List<ItemKeyDto> itemKeys = new ArrayList<>();
        for (ItemDto item : itemDtoList) {
            itemKeys.add(new ItemKeyDto(null,item));
        }
        batchFindGoodsCouponStock(itemKeys);
        return itemKeys;
    }

    @Override
    public ItemKeyDto transformItem(ItemDto item) {
        if(item==null){
            return null;
        }
        List<ItemDto> itemDtolist = Lists.newArrayList(item);
        return transformItemList(itemDtolist).get(0);
    }

	@Override
	public ItemKeyDto getItemKey(Long appItemId) {
		return itemKeyService.findItemKey(appItemId, null, null);
	}

	@Override
	public ItemKeyDto getItemKey(Long appId, Long itemId) {
		return itemKeyService.findItemKey(null, itemId, appId);
	}

	@Override
	public List<ItemKeyDto> getBatchItemKeyByAppItem(List<AppItemDto> appItems, Long appId) {
		List<Long> itemIds = new ArrayList<>();
		for (AppItemDto ai : appItems) {
			if (ai.getItemId() != null) {
				itemIds.add(ai.getItemId());
			}
		}
		List<ItemKeyDto> itemKeyList = new ArrayList<>();
		if (!itemIds.isEmpty()) {
			List<ItemEntity> itemEntitys = itemService.findByIds(itemIds);
			List<ItemDto> items = BeanUtils.copyList(itemEntitys, ItemDto.class);
			Map<Long, ItemDto> itemMap = new HashMap<>();
			for (ItemDto item : items) {
				itemMap.put(item.getId(), item);
			}
			for (AppItemDto ai : appItems) {
				ItemDto item = null;
				if (ai.getItemId() != null) {
					item = itemMap.get(ai.getItemId());
				}
				itemKeyList.add(new ItemKeyDto(ai, item, appId));
			}
		} else {
			for (AppItemDto ai : appItems) {
				itemKeyList.add(new ItemKeyDto(ai, null, appId));
			}
		}
		return itemKeyList;
	}
}
