package cn.com.duiba.goods.center.biz.dao;

import cn.com.duiba.goods.center.api.remoteservice.dto.AppItemClassifyDto;

/**
 * Created by xiaoxuda on 2016/11/17.
 */
public interface AppItemClassifyDao {
    /**
     * 根据id获取商品分类信息
     * @param id
     * @return
     */
    public AppItemClassifyDto find(Long id);
    
    /**
     * 查询最大的排序
     * @param classifyId
     * @return
     */
	public Integer findMaxPayload(Long classifyId);

	/**
	 * 修改自定义分类的排序
	 * @param appItemId
	 * @param classifyId
	 * @param payload
	 * @return
	 */
	public Integer updatePayload(Long appItemId, Long classifyId, Integer payload);
}
