package cn.com.duiba.goods.center.biz.dao;

import java.util.HashMap;
import java.util.Map;

import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * goods_coupon 数据源
 */
public class BaseCouponDao {

    @Autowired
    @Qualifier("couponSqlSessionTemplate")
    protected SqlSessionTemplate sqlSession;

    protected SqlSessionTemplate getSqlSession() {
        return sqlSession;
    }

    protected String getStamentNameSpace(String method) {
        return getClass().getName() + "." + method;
    }
    
    protected Map<String, Object> getBlankParams(){
        return new HashMap<>();
    }
    

    /**
     * 
     * 根据id对1024取余得到分表后缀<br/>
     * 主要是对gid这个类型来操作.<br/>
     *
     * @author xuhengfei
     * @param gid
     * @return
     * @since JDK 1.6
     */
    protected Map<String, Object> getTb1024SuffixParamsMap(Long gid){
        Map<String, Object> params=new HashMap<>();
        params.put("tb_suffix", getTableSuffix(gid));
        return params;
    }
    /**
     * 
     * 根据后缀的4位确定分表. <br/>
     * 主要是根据goodsCouponId来操作<br/>
     *
     * @author xuhengfei
     * @param goodsCouponId
     * @return
     * @since JDK 1.6
     */
    protected Map<String, Object> getTb1024ByLast4Number(Long goodsCouponId){
        Map<String, Object> params=new HashMap<>();
        String string=goodsCouponId+"";
        params.put("tb_suffix", string.substring(string.length()-4, string.length()));
        return params;
    }
    
    /**
     * getTableSuffix
     * @param id
     * @return
     */
    protected String getTableSuffix(Long id){
        Long tbInt=id.longValue()%1024;
        String tb=tbInt+"";
        if(tbInt<10){
            tb="000"+tbInt;
        }else if(tbInt<100){
            tb="00"+tbInt;
        }else if(tbInt<1000){
            tb="0"+tbInt;
        }
        
        return tb;
    }
}
