/**
 * Project Name:goods-center-biz
 * File Name:PCGFilterConfigDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年5月20日上午9:56:11
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao;

import java.util.List;

import cn.com.duiba.goods.center.biz.entity.PCGFilterConfigEntity;

/**
 * ClassName:PCGFilterConfigDao <br/>
 * Date:     2016年5月20日 上午9:56:11 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface PCGFilterConfigDao {

	/**
	 * insert
	 * @param appId
	 * @param type
	 * @param targetId
	 * @return
	 */
    Long insert(long appId,int type,long targetId);
    
    /**
     * delete
     * @param appId
     * @param type
     * @param targetId
     * @return
     */
    int delete(long appId,int type,long targetId);
    
    /**
     * select
     * @param id
     * @return
     */
    PCGFilterConfigEntity select(Long id);
    
    /**
     * 查询app下屏蔽券列表 <br/>
     * @param appId AppId
     * @param type  1:优惠券 2:分类 3:品牌
     * @return 
     */
     List<Long> selectPCGFilterTargetIds(Long appId,Integer type);
     
     /**
      * 查询商品归属品牌
      * @author zhengjy
      * @param goodsId 商品Id
      * @return pcgId
      */
     Long selectGoodsSeller(Long goodsId);
	 /**
	  * 查询商品归属类别
	  * @author zhengjy
	  * @param goodsId 商品Id
	  * @return pcgId
	  */
	 List<Long> selectGoodsCategory(Long goodsId);

	/**
	 *
	 * @param appId
	 * @param type
	 * @param targetId
	 * @return
	 */
	 PCGFilterConfigEntity select(long appId,int type,long targetId);
	 
}

