package cn.com.duiba.goods.center.biz.dao;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.SellerDto;

/**
 * 商家安全签名
 */
public interface SellerDao {

	/**
	 * 新增商家安全签名
	 * 
	 * @param black
	 * @return 如果失败,返回-1
	 */
	public int insertSeller(SellerDto sellerDto);

	/**
	 * 删除商家安全签名
	 * 
	 * @param id
	 * @return 如果失败,返回-1
	 * 
	 */
	public int deleteSeller(Long id);

	/**
	 * 商家安全签名列表
	 * 
	 * @param SellerDto
	 * @param offset
	 * @param max
	 * @return
	 */
	public List<SellerDto> findAll(SellerDto sellerDto, Integer offset, Integer max);

	/**
	 * 查询总数
	 *
	 * @param SellerDto
	 * @return Integer 总数
	 */
	public Integer findCount(SellerDto sellerDto);

	/**
	 * 通过ID返回对象
	 * 
	 * @param id
	 * @return SellerDto
	 */
	public SellerDto findById(Long id);

	/**
	 * 修改商家安全签名
	 * 
	 * @param SellerDto
	 */
	public int update(SellerDto sellerDto);
}
